/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TreeCloner
implements HashTreeTraverser {
    Logger log = LoggingManager.getLoggerFor((String)"jmeter.engine");
    ListedHashTree newTree;
    LinkedList objects = new LinkedList();
    boolean forThread = true;

    public TreeCloner() {
        this(true);
    }

    public TreeCloner(boolean forThread) {
        this.newTree = new ListedHashTree();
        this.forThread = forThread;
    }

    public void addNode(Object node, HashTree subTree) {
        if (!(this.forThread && node instanceof NoThreadClone || !(node instanceof TestElement))) {
            node = ((TestElement)node).clone();
            this.newTree.add((Collection)this.objects, node);
        } else {
            this.newTree.add((Collection)this.objects, node);
        }
        this.objects.addLast(node);
    }

    public void subtractNode() {
        this.objects.removeLast();
    }

    public ListedHashTree getClonedTree() {
        return this.newTree;
    }

    public void processPath() {
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testCloning() throws Exception {
            ListedHashTree original = new ListedHashTree();
            GenericController controller = new GenericController();
            controller.setName("controller");
            Arguments args = new Arguments();
            args.setName("args");
            TestPlan plan = new TestPlan();
            plan.addParameter("server", "jakarta");
            original.add((Object)controller, (Object)args);
            original.add((Object)plan);
            ResultCollector listener = new ResultCollector();
            listener.setName("Collector");
            original.add((Object)controller, (Object)listener);
            TreeCloner cloner = new TreeCloner();
            original.traverse((HashTreeTraverser)cloner);
            ListedHashTree newTree = cloner.getClonedTree();
            Assert.assertTrue((original != newTree ? 1 : 0) != 0);
            Assert.assertEquals((int)original.size(), (int)newTree.size());
            Assert.assertEquals((int)original.getTree(original.getArray()[0]).size(), (int)newTree.getTree(newTree.getArray()[0]).size());
            Assert.assertTrue((original.getArray()[0] != newTree.getArray()[0] ? 1 : 0) != 0);
            Assert.assertEquals((Object)((GenericController)original.getArray()[0]).getName(), (Object)((GenericController)newTree.getArray()[0]).getName());
            Assert.assertSame((Object)original.getTree(original.getArray()[0]).getArray()[1], (Object)newTree.getTree(newTree.getArray()[0]).getArray()[1]);
            TestPlan clonedTestPlan = (TestPlan)newTree.getArray()[1];
            clonedTestPlan.setRunningVersion(true);
            clonedTestPlan.recoverRunningVersion();
            Assert.assertTrue((!plan.getProperty("TestPlan.user_defined_variables").isRunningVersion() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)clonedTestPlan.getProperty("TestPlan.user_defined_variables").isRunningVersion());
            Arguments vars = (Arguments)plan.getProperty("TestPlan.user_defined_variables").getObjectValue();
            PropertyIterator iter = ((CollectionProperty)vars.getProperty("Arguments.arguments")).iterator();
            while (iter.hasNext()) {
                JMeterProperty argProp = iter.next();
                Assert.assertTrue((!argProp.isRunningVersion() ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(argProp.getObjectValue() instanceof Argument));
                Argument arg = (Argument)argProp.getObjectValue();
                arg.setValue("yahoo");
                Assert.assertEquals((Object)"yahoo", (Object)arg.getValue());
            }
            vars = (Arguments)clonedTestPlan.getProperty("TestPlan.user_defined_variables").getObjectValue();
            iter = vars.propertyIterator();
            while (iter.hasNext()) {
                Assert.assertTrue((boolean)iter.next().isRunningVersion());
            }
        }
    }
}

