/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.engine.util.ReplaceStringWithFunctions;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public class PackageTest
extends TestCase {
    Map variables;
    SampleResult result;
    ReplaceStringWithFunctions transformer;

    public PackageTest(String arg0) {
        super(arg0);
    }

    public void setUp() {
        this.variables = new HashMap();
        this.variables.put("my_regex", ".*");
        this.variables.put("server", "jakarta.apache.org");
        this.result = new SampleResult();
        this.result.setResponseData("<html>hello world</html> costs: $3.47,$5.67".getBytes());
        this.transformer = new ReplaceStringWithFunctions(new CompoundVariable(), this.variables);
        JMeterContextService.getContext().setVariables(new JMeterVariables());
        JMeterContextService.getContext().setSamplingStarted(true);
        JMeterContextService.getContext().setPreviousResult(this.result);
        JMeterContextService.getContext().getVariables().put("server", "jakarta.apache.org");
        JMeterContextService.getContext().getVariables().put("my_regex", ".*");
    }

    public void testFunctionParse1() throws Exception {
        StringProperty prop = new StringProperty("date", "${__javaScript((new Date().getDate() / 100).toString().substr(${__javaScript(1+1,d\\,ay)}\\,2),heute)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        newProp.recoverRunningVersion(null);
        Assert.assertTrue((Integer.parseInt(newProp.getStringValue()) > -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"2", (Object)JMeterContextService.getContext().getVariables().getObject("d,ay"));
    }

    public void testParseExample1() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(.*)</html>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"hello world", (Object)newProp.getStringValue());
    }

    public void testParseExample2() throws Exception {
        StringProperty prop = new StringProperty("html", "It should say:\\${${__regexFunction(<html>(.*)</html>,$1$)}}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"It should say:${hello world}", (Object)newProp.getStringValue());
    }

    public void testParseExample3() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(.*)</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"hello worldhellorld", (Object)newProp.getStringValue());
    }

    public void testParseExample4() throws Exception {
        StringProperty prop = new StringProperty("html", "${non-existing function}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"${non-existing function}", (Object)newProp.getStringValue());
    }

    public void testParseExample6() throws Exception {
        StringProperty prop = new StringProperty("html", "${server}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"jakarta.apache.org", (Object)newProp.getStringValue());
    }

    public void testParseExample5() throws Exception {
        StringProperty prop = new StringProperty("html", "");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.StringProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"", (Object)newProp.getStringValue());
    }

    public void testParseExample7() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(\\<([a-z]*)\\>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"html", (Object)newProp.getStringValue());
    }

    public void testParseExample8() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction((\\\\$\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"$3.47", (Object)newProp.getStringValue());
    }

    public void testParseExample9() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(([$]\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"$3.47", (Object)newProp.getStringValue());
    }

    public void testParseExample10() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(\\ (\\\\\\$\\d+\\.\\d+\\,\\\\$\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"$3.47,$5.67", (Object)newProp.getStringValue());
    }

    public void testNestedExample1() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(${my_regex})</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"hello worldhellorld", (Object)newProp.getStringValue());
    }

    public void testNestedExample2() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(${my_regex})</html>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)newProp.getClass().getName());
        Assert.assertEquals((Object)"hello world", (Object)newProp.getStringValue());
    }
}

