/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.engine.util.AbstractTransformer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.StringUtilities;

public class ReplaceFunctionsWithStrings
extends AbstractTransformer {
    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map variables) {
        this.setMasterFunction(masterFunction);
        this.setVariables(variables);
    }

    public JMeterProperty transformValue(JMeterProperty prop) throws InvalidVariableException {
        Iterator iter = this.getVariables().keySet().iterator();
        String input = prop.getStringValue();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.getVariables().get(key);
            input = StringUtilities.substitute(input, value, "${" + key + "}");
        }
        StringProperty newProp = new StringProperty(prop.getName(), input);
        return newProp;
    }
}

