/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.engine.util.ReplaceFunctionsWithStrings;
import org.apache.jmeter.engine.util.ReplaceStringWithFunctions;
import org.apache.jmeter.engine.util.UndoVariableReplacement;
import org.apache.jmeter.engine.util.ValueTransformer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ValueReplacer {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    CompoundVariable masterFunction = new CompoundVariable();
    Map variables = new HashMap();
    TestPlan tp;

    public ValueReplacer() {
        this.tp = new TestPlan();
    }

    public ValueReplacer(TestPlan tp) {
        this.tp = tp;
        this.setUserDefinedVariables(tp.getUserDefinedVariables());
    }

    public void setUserDefinedVariables(Map variables) {
        this.variables = variables;
    }

    public void replaceValues(TestElement el) throws InvalidVariableException {
        Collection newProps = this.replaceValues(el.propertyIterator(), new ReplaceStringWithFunctions(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    private void setProperties(TestElement el, Collection newProps) {
        Iterator iter = newProps.iterator();
        el.clear();
        while (iter.hasNext()) {
            el.setProperty((JMeterProperty)iter.next());
        }
    }

    public void reverseReplace(TestElement el) throws InvalidVariableException {
        Collection newProps = this.replaceValues(el.propertyIterator(), new ReplaceFunctionsWithStrings(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    public void undoReverseReplace(TestElement el) throws InvalidVariableException {
        Collection newProps = this.replaceValues(el.propertyIterator(), new UndoVariableReplacement(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    public void addVariable(String name, String value) {
        this.tp.addParameter(name, value);
        this.setUserDefinedVariables(this.tp.getUserDefinedVariables());
    }

    private Collection replaceValues(PropertyIterator iter, ValueTransformer transform) throws InvalidVariableException {
        LinkedList<JMeterProperty> props = new LinkedList<JMeterProperty>();
        while (iter.hasNext()) {
            JMeterProperty val = iter.next();
            if (val instanceof StringProperty) {
                val = transform.transformValue((StringProperty)val);
            } else if (val instanceof MultiProperty) {
                MultiProperty multiVal = (MultiProperty)val;
                Collection newValues = this.replaceValues(multiVal.iterator(), transform);
                multiVal.clear();
                Iterator propIter = newValues.iterator();
                while (propIter.hasNext()) {
                    multiVal.addProperty((JMeterProperty)propIter.next());
                }
            }
            props.add(val);
        }
        return props;
    }

    public static class Test
    extends TestCase {
        TestPlan variables;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.variables = new TestPlan();
            this.variables.addParameter("server", "jakarta.apache.org");
            this.variables.addParameter("username", "jack");
            this.variables.addParameter("password", "jacks_password");
            this.variables.addParameter("regex", ".*");
            JMeterVariables vars = new JMeterVariables();
            vars.put("server", "jakarta.apache.org");
            JMeterContextService.getContext().setVariables(vars);
            JMeterContextService.getContext().setSamplingStarted(true);
        }

        public void testReverseReplacement() throws Exception {
            ValueReplacer replacer = new ValueReplacer(this.variables);
            Assert.assertTrue((boolean)this.variables.getUserDefinedVariables().containsKey("server"));
            Assert.assertTrue((boolean)replacer.variables.containsKey("server"));
            TestPlan element = new TestPlan();
            element.setProperty(new StringProperty("domain", "jakarta.apache.org"));
            List args = new ArrayList<String>();
            args.add("username is jack");
            args.add("jacks_password");
            element.setProperty(new CollectionProperty("args", args));
            replacer.reverseReplace(element);
            Assert.assertEquals((Object)"${server}", (Object)element.getPropertyAsString("domain"));
            args = (List)element.getProperty("args").getObjectValue();
            Assert.assertEquals((Object)"${password}", (Object)((JMeterProperty)args.get(1)).getStringValue());
        }

        public void testReplace() throws Exception {
            ValueReplacer replacer = new ValueReplacer();
            replacer.setUserDefinedVariables(this.variables.getUserDefinedVariables());
            ConfigTestElement element = new ConfigTestElement();
            element.setProperty(new StringProperty("domain", "${server}"));
            replacer.replaceValues(element);
            log.debug("domain property = " + element.getProperty("domain"));
            element.setRunningVersion(true);
            Assert.assertEquals((Object)"jakarta.apache.org", (Object)element.getPropertyAsString("domain"));
        }

        protected void tearDown() throws Exception {
            JMeterContextService.getContext().setSamplingStarted(false);
        }
    }
}

