/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public abstract class AbstractFunction
implements Function {
    private Map threadVariables = new HashMap();

    public abstract String execute(SampleResult var1, Sampler var2) throws InvalidVariableException;

    public String execute() throws InvalidVariableException {
        JMeterContext context = JMeterContextService.getContext();
        SampleResult previousResult = context.getPreviousResult();
        Sampler currentSampler = context.getCurrentSampler();
        return this.execute(previousResult, currentSampler);
    }

    public abstract void setParameters(Collection var1) throws InvalidVariableException;

    public abstract String getReferenceKey();

    protected Collection parseArguments(String params) {
        StringTokenizer tk = new StringTokenizer(params, ",", true);
        LinkedList<String> arguments = new LinkedList<String>();
        String previous = "";
        while (tk.hasMoreTokens()) {
            String arg = tk.nextToken();
            if (arg.equals(",") && previous.equals(",")) {
                arguments.add("");
            } else if (!arg.equals(",")) {
                arguments.add(URLDecoder.decode(arg));
            }
            previous = arg;
        }
        return arguments;
    }

    protected JMeterVariables getVariables() {
        return JMeterContextService.getContext().getVariables();
    }
}

