/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.jmeter.gui.JMeterGUIComponent;

public class GUIFactory {
    private static final Map GUI_MAP = new HashMap();
    private static final Map ICON_MAP = new HashMap();

    private GUIFactory() {
    }

    public static ImageIcon getIcon(Class elementClass) {
        String key = elementClass.getName();
        ImageIcon icon = (ImageIcon)ICON_MAP.get(key);
        if (icon != null) {
            return icon;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getIcon(elementClass.getSuperclass());
        }
        return null;
    }

    public static JComponent getGUI(Class elementClass) {
        String key = elementClass.getName();
        JComponent gui = (JComponent)GUI_MAP.get(key);
        if (gui != null) {
            return gui;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getGUI(elementClass.getSuperclass());
        }
        return null;
    }

    public static void registerIcon(String key, ImageIcon icon) {
        ICON_MAP.put(key, icon);
    }

    public static void registerGUI(String key, Class guiClass) throws InstantiationException, IllegalAccessException {
        JMeterGUIComponent gui = (JMeterGUIComponent)guiClass.newInstance();
        JComponent component = (JComponent)((Object)gui);
        GUI_MAP.put(key, gui);
    }
}

