/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GuiPackage {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static GuiPackage guiPack;
    private boolean dirty = false;
    private Map nodesToGui = new HashMap();
    private Map guis = new HashMap();
    private JMeterTreeNode currentNode = null;
    private JMeterTreeModel treeModel;
    private JMeterTreeListener treeListener;
    private MainFrame mainFrame;

    private GuiPackage() {
    }

    public static GuiPackage getInstance() {
        return guiPack;
    }

    public static GuiPackage getInstance(JMeterTreeListener listener, JMeterTreeModel treeModel) {
        if (guiPack == null) {
            guiPack = new GuiPackage();
            guiPack.setTreeListener(listener);
            guiPack.setTreeModel(treeModel);
        }
        return guiPack;
    }

    public JMeterGUIComponent getGui(TestElement node) {
        return this.getGui(node, node.getPropertyAsString("TestElement.gui_class"));
    }

    public JMeterGUIComponent getGui(TestElement node, String guiClass) {
        log.debug("Getting gui for " + node);
        try {
            JMeterGUIComponent comp = (JMeterGUIComponent)this.nodesToGui.get(node);
            log.debug("Gui retrieved = " + comp);
            if (comp == null) {
                comp = this.getGuiFromCache(guiClass);
                this.nodesToGui.put(node, comp);
            }
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public void removeNode(TestElement node) {
        this.nodesToGui.remove(node);
    }

    public JMeterGUIComponent getCurrentGui() {
        try {
            TestElement currentNode = this.treeListener.getCurrentNode().createTestElement();
            JMeterGUIComponent comp = this.getGui(currentNode);
            if (!(comp instanceof AbstractVisualizer)) {
                comp.clear();
            }
            comp.configure(currentNode);
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.treeModel.getNodeOf(userObject);
    }

    public TestElement createTestElement(String guiClass) {
        try {
            JMeterGUIComponent comp = this.getGuiFromCache(guiClass);
            comp.clear();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    private JMeterGUIComponent getGuiFromCache(String guiClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        JMeterGUIComponent comp = (JMeterGUIComponent)this.guis.get(guiClass);
        if (comp == null && !((comp = (JMeterGUIComponent)Class.forName(guiClass).newInstance()) instanceof UnsharedComponent)) {
            this.guis.put(guiClass, comp);
        }
        return comp;
    }

    public void updateCurrentGui() {
        if (this.currentNode != null) {
            TestElement element = this.currentNode.createTestElement();
            JMeterGUIComponent comp = this.getGui(element);
            comp.configure(element);
        }
    }

    public void updateCurrentNode() {
        try {
            if (this.currentNode != null) {
                log.debug("Updating current node " + this.currentNode.createTestElement());
                JMeterGUIComponent comp = this.getGui(this.currentNode.createTestElement());
                TestElement el = this.currentNode.createTestElement();
                comp.modifyTestElement(el);
            }
            this.currentNode = this.treeListener.getCurrentNode();
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
        }
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public HashTree addSubTree(HashTree subTree) throws IllegalUserActionException {
        return this.treeModel.addSubTree(subTree, this.treeListener.getCurrentNode());
    }

    public HashTree getCurrentSubTree() {
        return this.treeModel.getCurrentSubTree(this.treeListener.getCurrentNode());
    }

    public JMeterTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(JMeterTreeModel newTreeModel) {
        this.treeModel = newTreeModel;
    }

    public ValueReplacer getReplacer() {
        return new ValueReplacer((TestPlan)((JMeterGUIComponent)this.getTreeModel().getTestPlan().getArray()[0]).createTestElement());
    }

    public void setMainFrame(MainFrame newMainFrame) {
        this.mainFrame = newMainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setTreeListener(JMeterTreeListener newTreeListener) {
        this.treeListener = newTreeListener;
    }

    public JMeterTreeListener getTreeListener() {
        return this.treeListener;
    }

    public void displayPopUp(MouseEvent e, JPopupMenu popup) {
        this.displayPopUp((Component)e.getSource(), e, popup);
    }

    public void displayPopUp(Component invoker, MouseEvent e, JPopupMenu popup) {
        if (popup != null) {
            log.debug("Showing pop up for " + invoker + " at x,y = " + e.getX() + "," + e.getY());
            popup.pack();
            popup.show(invoker, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocus();
        }
    }
}

