/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;

public class NamePanel
extends JPanel
implements JMeterGUIComponent {
    private JTextField nameField = new JTextField(15);
    private JLabel nameLabel;
    private JMeterTreeNode node;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$WorkBench;

    public NamePanel() {
        this.setName(this.getStaticLabel());
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        this.nameLabel = new JLabel(JMeterUtils.getResString("name"));
        this.nameLabel.setName("name");
        this.nameLabel.setLabelFor(this.nameField);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                NamePanel.this.updateName(NamePanel.this.nameField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                NamePanel.this.updateName(NamePanel.this.nameField.getText());
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)this.nameLabel, "West");
        this.add((Component)this.nameField, "Center");
    }

    public void clear() {
        this.setName(this.getStaticLabel());
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setName(String name) {
        super.setName(name);
        this.nameField.setText(name);
    }

    protected JMeterTreeNode getNode() {
        return this.node;
    }

    public void setNode(JMeterTreeNode node) {
        this.node = node;
    }

    public void configure(TestElement testElement) {
        this.setName(testElement.getPropertyAsString("TestElement.name"));
    }

    public JPopupMenu createPopupMenu() {
        return null;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("root");
    }

    public Collection getMenuCategories() {
        return null;
    }

    public TestElement createTestElement() {
        WorkBench wb = new WorkBench();
        this.modifyTestElement(wb);
        return wb;
    }

    public void modifyTestElement(TestElement wb) {
        wb.setProperty(new StringProperty("TestElement.name", this.getName()));
        wb.setProperty(new StringProperty("TestElement.gui_class", this.getClass().getName()));
        wb.setProperty(new StringProperty("TestElement.test_class", (class$org$apache$jmeter$testelement$WorkBench == null ? (class$org$apache$jmeter$testelement$WorkBench = NamePanel.class$("org.apache.jmeter.testelement.WorkBench")) : class$org$apache$jmeter$testelement$WorkBench).getName()));
    }

    private void updateName(String newValue) {
        if (this.getNode() != null) {
            this.getNode().nameChanged();
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.nameLabel.setText(JMeterUtils.getResString(this.nameLabel.getName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

