/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.control.gui.WorkBenchGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.action.Save;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Load
implements Command {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static Set commands = new HashSet();

    public Set getActionNames() {
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doAction(ActionEvent e) {
        File f;
        boolean isTestPlan;
        block8: {
            JFileChooser chooser = FileDialoger.promptToOpenFile(new String[]{".jmx"});
            if (chooser == null) {
                return;
            }
            isTestPlan = false;
            FileInputStream reader = null;
            f = null;
            try {
                block7: {
                    try {
                        f = chooser.getSelectedFile();
                        if (f == null) break block7;
                        log.info("Loading file: " + f);
                        reader = new FileInputStream(f);
                        HashTree tree = SaveService.loadSubTree(reader);
                        isTestPlan = this.insertLoadedTree(e.getID(), tree);
                    }
                    catch (Exception ex) {
                        String msg = ex.getMessage();
                        if (msg == null) {
                            msg = "Unexpected error - see log for details";
                            log.warn("Unexpected error", (Throwable)ex);
                        }
                        JMeterUtils.reportErrorToUser(msg);
                        Object var9_9 = null;
                        GuiPackage.getInstance().updateCurrentGui();
                        GuiPackage.getInstance().getMainFrame().repaint();
                        break block8;
                    }
                }
                Object var9_8 = null;
                GuiPackage.getInstance().updateCurrentGui();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                GuiPackage.getInstance().updateCurrentGui();
                GuiPackage.getInstance().getMainFrame().repaint();
                throw throwable;
            }
            GuiPackage.getInstance().getMainFrame().repaint();
        }
        if (isTestPlan && f != null) {
            ((Save)ActionRouter.getInstance().getAction("save", "org.apache.jmeter.gui.action.Save")).setTestPlanFile(f.getAbsolutePath());
        }
    }

    public boolean insertLoadedTree(int id, HashTree tree) throws Exception, IllegalUserActionException {
        if (tree == null) {
            throw new Exception("Error in TestPlan - see log file");
        }
        boolean isTestPlan = tree.getArray()[0] instanceof TestPlan;
        HashTree newTree = GuiPackage.getInstance().addSubTree(tree);
        GuiPackage.getInstance().updateCurrentGui();
        GuiPackage.getInstance().getMainFrame().getTree().setSelectionPath(new TreePath(((JMeterTreeNode)newTree.getArray()[0]).getPath()));
        tree = GuiPackage.getInstance().getCurrentSubTree();
        ActionRouter.getInstance().actionPerformed(new ActionEvent(tree.get(tree.getArray()[tree.size() - 1]), id, "sub_tree_loaded"));
        return isTestPlan;
    }

    private void convertTree(HashTree tree) throws Exception {
        Iterator iter = new LinkedList(tree.list()).iterator();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            this.convertTree(tree.getTree((Object)item));
            JMeterGUIComponent comp = this.generateGUIComponent(item);
            tree.replace((Object)item, (Object)comp);
        }
    }

    private JMeterGUIComponent generateGUIComponent(TestElement item) throws Exception {
        JMeterGUIComponent gui = null;
        try {
            gui = (JMeterGUIComponent)Class.forName(item.getPropertyAsString("TestElement.gui_class")).newInstance();
        }
        catch (Exception e) {
            log.warn("Couldn't get gui for " + item, (Throwable)e);
            gui = new WorkBenchGui();
        }
        gui.configure(item);
        return gui;
    }

    static {
        commands.add("open");
    }

    public static class Test
    extends TestCase {
        File testFile1;
        File testFile2;
        File testFile3;
        File testFile4;
        File testFile5;
        File testFile6;
        File testFile7;
        File testFile8;
        File testFile9;
        File testFile10;
        File testFile11;
        File testFile12;
        File testFile13;
        static Load loader = new Load();

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.testFile1 = new File(System.getProperty("user.dir") + "/testfiles", "Test Plan.jmx");
            this.testFile2 = new File(System.getProperty("user.dir") + "/testfiles", "Modification Manager.jmx");
            this.testFile3 = new File(System.getProperty("user.dir") + "/testfiles", "proxy.jmx");
            this.testFile4 = new File(System.getProperty("user.dir") + "/testfiles", "AssertionTestPlan.jmx");
            this.testFile5 = new File(System.getProperty("user.dir") + "/testfiles", "AuthManagerTestPlan.jmx");
            this.testFile6 = new File(System.getProperty("user.dir") + "/testfiles", "HeaderManagerTestPlan.jmx");
            this.testFile7 = new File(System.getProperty("user.dir") + "/testfiles", "InterleaveTestPlan.jmx");
            this.testFile8 = new File(System.getProperty("user.dir") + "/testfiles", "InterleaveTestPlan2.jmx");
            this.testFile9 = new File(System.getProperty("user.dir") + "/testfiles", "LoopTestPlan.jmx");
            this.testFile10 = new File(System.getProperty("user.dir") + "/testfiles", "OnceOnlyTestPlan.jmx");
            this.testFile11 = new File(System.getProperty("user.dir") + "/testfiles", "ProxyServerTestPlan.jmx");
            this.testFile12 = new File(System.getProperty("user.dir") + "/testfiles", "SimpleTestPlan.jmx");
            this.testFile13 = new File(System.getProperty("user.dir") + "/testfiles", "URLRewritingExample.jmx");
        }

        public void testFile3() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile3));
        }

        private void loadAndAssertTree(HashTree tree) throws Exception {
            Assert.assertTrue((boolean)(tree.getArray()[0] instanceof TestPlan));
            Test.loader.convertTree(tree);
            Assert.assertTrue((boolean)(tree.getArray()[0] instanceof TestPlanGui));
        }

        public void testFile4() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile4));
        }

        public void testFile5() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile5));
        }

        public void testFile6() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile6));
        }

        public void testFile7() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile7));
        }

        public void testFile8() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile8));
        }

        public void testFile9() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile9));
        }

        public void testFile10() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile10));
        }

        public void testFile11() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile11));
        }

        public void testFile12() throws Exception {
            this.loadAndAssertTree(this.getTree(this.testFile12));
        }

        private HashTree getTree(File f) throws Exception {
            FileInputStream reader = new FileInputStream(f);
            HashTree tree = SaveService.loadSubTree(reader);
            return tree;
        }
    }
}

