/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;

public class LookAndFeelCommand
implements Command {
    private static Set commands = new HashSet();

    public void doAction(ActionEvent ev) {
        try {
            String className = ev.getActionCommand().substring(4).replace('/', '.');
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(GuiPackage.getInstance().getMainFrame());
        }
        catch (UnsupportedLookAndFeelException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (InstantiationException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (ClassNotFoundException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (IllegalAccessException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lfs.length) {
            commands.add("laf:" + lfs[i].getClassName());
            ++i;
        }
        try {
            String defaultUI = JMeterUtils.getPropDefault("jmeter.laf", UIManager.getCrossPlatformLookAndFeelClassName());
            UIManager.setLookAndFeel(defaultUI);
        }
        catch (Exception e) {}
    }
}

