/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteStart
extends AbstractAction {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    private static Set commands = new HashSet();
    private Map remoteEngines = new HashMap();

    public void doAction(ActionEvent e) {
        block5: {
            String action;
            block7: {
                String el;
                block6: {
                    String name;
                    block4: {
                        name = ((Component)e.getSource()).getName();
                        if (name != null) {
                            name = name.trim();
                        }
                        if (!(action = e.getActionCommand()).equals("remote_stop")) break block4;
                        this.doRemoteStop(name);
                        break block5;
                    }
                    if (!action.equals("remote_start")) break block6;
                    this.doRemoteInit(name);
                    this.doRemoteStart(name);
                    break block5;
                }
                if (!action.equals("remote_start_all")) break block7;
                String remote_hosts_string = JMeterUtils.getPropDefault("remote_hosts", "127.0.0.1");
                StringTokenizer st = new StringTokenizer(remote_hosts_string, ",");
                while (st.hasMoreElements()) {
                    el = (String)st.nextElement();
                    this.doRemoteInit(el.trim());
                }
                st = new StringTokenizer(remote_hosts_string, ",");
                while (st.hasMoreElements()) {
                    el = (String)st.nextElement();
                    this.doRemoteStart(el.trim());
                }
                break block5;
            }
            if (!action.equals("remote_stop_all")) break block5;
            String remote_hosts_string = JMeterUtils.getPropDefault("remote_hosts", "127.0.0.1");
            StringTokenizer st = new StringTokenizer(remote_hosts_string, ",");
            while (st.hasMoreElements()) {
                String el = (String)st.nextElement();
                this.doRemoteStop(el.trim());
            }
        }
    }

    private void doRemoteStop(String name) {
        GuiPackage.getInstance().getMainFrame().showStoppingMessage(name);
        JMeterEngine engine = (JMeterEngine)this.remoteEngines.get(name);
        engine.stopTest();
    }

    private void doRemoteStart(String name) {
        JMeterEngine engine = (JMeterEngine)this.remoteEngines.get(name);
        if (engine == null) {
            try {
                engine = new ClientJMeterEngine(name);
                this.remoteEngines.put(name, engine);
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
                JMeterUtils.reportErrorToUser("Bad call to remote host");
                return;
            }
        } else {
            engine.reset();
        }
        this.startEngine(engine, name);
    }

    private void doRemoteInit(String name) {
        JMeterEngine engine = (JMeterEngine)this.remoteEngines.get(name);
        if (engine == null) {
            try {
                engine = new ClientJMeterEngine(name);
                this.remoteEngines.put(name, engine);
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
                JMeterUtils.reportErrorToUser("Bad call to remote host");
                return;
            }
        } else {
            engine.reset();
        }
        this.initEngine(engine, name);
    }

    public Set getActionNames() {
        return commands;
    }

    private void initEngine(JMeterEngine engine, String host) {
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        this.convertSubTree(testTree);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        engine.configure(testTree);
    }

    private void startEngine(JMeterEngine engine, String host) {
        GuiPackage gui = GuiPackage.getInstance();
        try {
            engine.runTest();
        }
        catch (JMeterEngineException e) {
            JOptionPane.showMessageDialog(gui.getMainFrame(), e.getMessage(), JMeterUtils.getResString("Error Occurred"), 0);
        }
    }

    static {
        commands.add("remote_start");
        commands.add("remote_stop");
        commands.add("remote_start_all");
        commands.add("remote_stop_all");
    }
}

