/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;

public class SSLManagerCommand
implements Command {
    private static Set commandSet;
    private JFileChooser keyStoreChooser;

    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("sslManager")) {
            this.sslManager();
        }
    }

    public Set getActionNames() {
        return commandSet;
    }

    private void sslManager() {
        SSLManager.reset();
        this.keyStoreChooser = new JFileChooser(JMeterUtils.getJMeterProperties().getProperty("user.dir"));
        this.keyStoreChooser.addChoosableFileFilter(new AcceptPKCS12FileFilter());
        this.keyStoreChooser.setFileSelectionMode(0);
        int retVal = this.keyStoreChooser.showOpenDialog(GuiPackage.getInstance().getMainFrame());
        if (0 == retVal) {
            File selectedFile = this.keyStoreChooser.getSelectedFile();
            try {
                JMeterUtils.getJMeterProperties().setProperty("javax.net.ssl.keyStore", selectedFile.getCanonicalPath());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.keyStoreChooser = null;
        SSLManager.getInstance();
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("sslManager");
        commandSet = Collections.unmodifiableSet(commands);
    }

    private static class AcceptPKCS12FileFilter
    extends FileFilter {
        private AcceptPKCS12FileFilter() {
        }

        public String getDescription() {
            return JMeterUtils.getResString("pkcs12_desc");
        }

        public boolean accept(File testFile) {
            return testFile.isDirectory() || testFile.getName().endsWith(".p12") || testFile.getName().endsWith(".P12");
        }
    }
}

