/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JFileChooser;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Save
implements Command {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    public static final String SAVE_ALL = "save_all";
    public static final String SAVE = "save_as";
    public static final String SAVE_TO_PREVIOUS = "save";
    private String chosenFile;
    private String testPlanFile;
    private static Set commands = new HashSet();

    public Set getActionNames() {
        return commands;
    }

    public void setTestPlanFile(String f) {
        this.testPlanFile = f;
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HashTree subTree = null;
        if (e.getActionCommand().equals(SAVE)) {
            subTree = GuiPackage.getInstance().getCurrentSubTree();
        } else if (e.getActionCommand().equals(SAVE_ALL) || e.getActionCommand().equals(SAVE_TO_PREVIOUS)) {
            subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        }
        if (!SAVE_TO_PREVIOUS.equals(e.getActionCommand()) || this.testPlanFile == null) {
            JFileChooser chooser = FileDialoger.promptToSaveFile(GuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + ".jmx");
            if (chooser == null) {
                return;
            }
            this.chosenFile = e.getActionCommand().equals(SAVE_ALL) || e.getActionCommand().equals(SAVE_TO_PREVIOUS) ? (this.testPlanFile = chooser.getSelectedFile().getAbsolutePath()) : chooser.getSelectedFile().getAbsolutePath();
        } else {
            this.chosenFile = this.testPlanFile;
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
        try {
            this.convertSubTree(subTree);
        }
        catch (Exception err) {
            // empty catch block
        }
        FileOutputStream writer = null;
        try {
            try {
                writer = new FileOutputStream(this.chosenFile);
                SaveService.saveSubTree(subTree, writer);
            }
            catch (Throwable ex) {
                this.testPlanFile = null;
                log.error("", ex);
                throw new IllegalUserActionException("Couldn't save test plan to file: " + this.chosenFile);
            }
            Object var6_5 = null;
            this.closeWriter(writer);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closeWriter(writer);
            GuiPackage.getInstance().getMainFrame().repaint();
            throw throwable;
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    private void convertSubTree(HashTree tree) {
        Iterator iter = new LinkedList(tree.list()).iterator();
        while (iter.hasNext()) {
            JMeterTreeNode item = (JMeterTreeNode)iter.next();
            this.convertSubTree(tree.getTree((Object)item));
            TestElement testElement = item.createTestElement();
            tree.replace((Object)item, (Object)testElement);
        }
    }

    private void closeWriter(OutputStream writer) {
        block2: {
            if (writer == null) break block2;
            try {
                writer.close();
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
    }

    static {
        commands.add(SAVE);
        commands.add(SAVE_ALL);
        commands.add(SAVE_TO_PREVIOUS);
    }

    public static class Test
    extends TestCase {
        Save save;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.save = new Save();
        }

        public void testTreeConversion() throws Exception {
            ListedHashTree tree = new ListedHashTree();
            JMeterTreeNode root = new JMeterTreeNode(new Arguments(), null);
            tree.add((Object)root, (Object)root);
            tree.getTree((Object)root).add((Object)root, (Object)root);
            this.save.convertSubTree((HashTree)tree);
            Assert.assertEquals((Object)tree.getArray()[0].getClass().getName(), (Object)root.createTestElement().getClass().getName());
            tree = tree.getTree(tree.getArray()[0]);
            Assert.assertEquals((Object)tree.getArray()[0].getClass().getName(), (Object)root.createTestElement().getClass().getName());
            Assert.assertEquals((Object)tree.getTree(tree.getArray()[0]).getArray()[0].getClass().getName(), (Object)root.createTestElement().getClass().getName());
        }
    }
}

