/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.control.gui.WorkBenchGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterTreeListener
implements TreeSelectionListener,
MouseListener,
KeyListener,
MouseMotionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    Container endWindow;
    JPopupMenu pop;
    TreePath currentPath;
    ActionListener actionHandler;
    private JMeterTreeModel model;
    private JTree tree;
    private boolean dragging = false;
    private JMeterTreeNode draggedNode;
    private JLabel dragIcon = new JLabel(JMeterUtils.getImage("leafnode.gif"));

    public JMeterTreeListener(JMeterTreeModel model) {
        this.model = model;
        this.dragIcon.validate();
        this.dragIcon.setVisible(true);
    }

    public JMeterTreeListener() {
        this.dragIcon.validate();
        this.dragIcon.setVisible(true);
    }

    public void setModel(JMeterTreeModel m) {
        this.model = m;
    }

    public void setActionHandler(ActionListener ah) {
        this.actionHandler = ah;
    }

    public void setJTree(JTree tree) {
        this.tree = tree;
    }

    public void setEndWindow(Container window) {
        this.endWindow = window;
    }

    public JTree getJTree() {
        return this.tree;
    }

    public JMeterTreeNode getCurrentNode() {
        if (this.currentPath != null) {
            if (this.currentPath.getLastPathComponent() != null) {
                return (JMeterTreeNode)this.currentPath.getLastPathComponent();
            }
            return (JMeterTreeNode)this.currentPath.getParentPath().getLastPathComponent();
        }
        return (JMeterTreeNode)this.model.getRoot();
    }

    public JMeterTreeNode[] getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return new JMeterTreeNode[]{this.getCurrentNode()};
        }
        JMeterTreeNode[] nodes = new JMeterTreeNode[paths.length];
        int i = 0;
        while (i < paths.length) {
            nodes[i] = (JMeterTreeNode)paths[i].getLastPathComponent();
            ++i;
        }
        return nodes;
    }

    public void removedSelectedNode() {
        this.currentPath = this.currentPath.getParentPath();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.currentPath = e.getNewLeadSelectionPath();
        this.actionHandler.actionPerformed(new ActionEvent(this, 3333, "edit"));
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging && this.isValidDragAction(this.draggedNode, this.getCurrentNode())) {
            this.dragging = false;
            JPopupMenu dragNdrop = new JPopupMenu();
            JMenuItem item = new JMenuItem(JMeterUtils.getResString("Insert Before"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.insert_before");
            dragNdrop.add(item);
            item = new JMenuItem(JMeterUtils.getResString("Insert After"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.insert_after");
            dragNdrop.add(item);
            item = new JMenuItem(JMeterUtils.getResString("Add as Child"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.add");
            dragNdrop.add(item);
            dragNdrop.addSeparator();
            item = new JMenuItem(JMeterUtils.getResString("Cancel"));
            dragNdrop.add(item);
            this.displayPopUp(e, dragNdrop);
        } else {
            GuiPackage.getInstance().getMainFrame().repaint();
        }
        this.dragging = false;
    }

    public JMeterTreeNode getDraggedNode() {
        return this.draggedNode;
    }

    private boolean isValidDragAction(JMeterTreeNode source, JMeterTreeNode dest) {
        boolean isValid = true;
        TreeNode[] path = dest.getPath();
        int i = 0;
        while (i < path.length) {
            if (path[i] == source) {
                isValid = false;
            }
            ++i;
        }
        return isValid;
    }

    public void mouseEntered(MouseEvent e) {
    }

    private void changeSelectionIfDragging(MouseEvent e) {
        if (this.dragging) {
            GuiPackage.getInstance().getMainFrame().drawDraggedComponent(this.dragIcon, e.getX(), e.getY());
            if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
                if (this.getCurrentNode() != this.draggedNode) {
                    this.tree.setSelectionPath(this.currentPath);
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        MainFrame mainFrame = GuiPackage.getInstance().getMainFrame();
        mainFrame.closeMenu();
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
            this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
        }
        if (selRow != -1 && this.isRightClick(e)) {
            if (this.tree.getSelectionCount() < 2) {
                this.tree.setSelectionPath(this.currentPath);
            }
            if (this.getCurrentNode() instanceof JMeterGUIComponent) {
                log.debug("About to display pop-up");
                this.displayPopUp(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            this.dragging = true;
            this.draggedNode = this.getCurrentNode();
            if (this.draggedNode.getUserObject() instanceof TestPlanGui || this.draggedNode.getUserObject() instanceof WorkBenchGui) {
                this.dragging = false;
            }
        }
        this.changeSelectionIfDragging(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private boolean isRightClick(MouseEvent e) {
        return (8 & e.getModifiers()) > 0 || 4 == e.getModifiers();
    }

    private void updateMainMenu(JPopupMenu menu) {
        try {
            MainFrame mainFrame = GuiPackage.getInstance().getMainFrame();
            mainFrame.setEditMenu(menu);
        }
        catch (NullPointerException e) {
            log.error("Null pointer: JMeterTreeListener.updateMenuItem()", (Throwable)e);
            log.error("", (Throwable)e);
        }
    }

    private void displayPopUp(MouseEvent e) {
        JPopupMenu pop = this.getCurrentNode().createPopupMenu();
        GuiPackage.getInstance().displayPopUp(e, pop);
    }

    private void displayPopUp(MouseEvent e, JPopupMenu popup) {
        log.warn("Shouldn't be here");
        if (popup != null) {
            popup.pack();
            popup.show(this.tree, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocus();
        }
    }
}

