/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterTreeNode
extends DefaultMutableTreeNode
implements JMeterGUIComponent {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    JMeterTreeModel treeModel;
    boolean enabled = true;

    public JMeterTreeNode(TestElement userObj, JMeterTreeModel treeModel) {
        super(userObj);
        this.treeModel = treeModel;
    }

    public boolean isEnabled() {
        return ((AbstractTestElement)this.createTestElement()).getPropertyAsBoolean("TestElement.enabled");
    }

    public void setEnabled(boolean enabled) {
        this.createTestElement().setProperty(new BooleanProperty("TestElement.enabled", enabled));
    }

    public void clear() {
    }

    public ImageIcon getIcon() {
        try {
            return GUIFactory.getIcon(Class.forName(this.createTestElement().getPropertyAsString("TestElement.gui_class")));
        }
        catch (ClassNotFoundException e) {
            log.warn("Can't get icon for class " + this.createTestElement(), (Throwable)e);
            return null;
        }
    }

    public Collection getMenuCategories() {
        try {
            return GuiPackage.getInstance().getGui(this.createTestElement()).getMenuCategories();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu createPopupMenu() {
        try {
            return GuiPackage.getInstance().getGui(this.createTestElement()).createPopupMenu();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public void configure(TestElement element) {
    }

    public void modifyTestElement(TestElement el) {
    }

    public TestElement createTestElement() {
        return (TestElement)this.getUserObject();
    }

    public String getStaticLabel() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getStaticLabel();
    }

    public void setName(String name) {
        ((TestElement)this.getUserObject()).setProperty(new StringProperty("TestElement.name", name));
    }

    public String getName() {
        return ((TestElement)this.getUserObject()).getPropertyAsString("TestElement.name");
    }

    public void setNode(JMeterTreeNode node) {
    }

    public void nameChanged() {
        this.treeModel.nodeChanged(this);
    }
}

