/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JTextField;

public class JDateField
extends JTextField {
    private static final DateFormat dateFormat = new SimpleDateFormat("MM/d/yyyy HH:mm:ss");

    public JDateField(Date date) {
        super(20);
        this.addKeyListener(new KeyFocus());
        this.addFocusListener(new FocusClass());
        String myString = dateFormat.format(date);
        this.setText(myString);
    }

    public void setDate(Date date) {
        this.setText(dateFormat.format(date));
    }

    public Date getDate() {
        try {
            return dateFormat.parse(this.getText());
        }
        catch (Exception e) {
            return new Date();
        }
    }

    class FocusClass
    implements FocusListener {
        FocusClass() {
        }

        public void focusGained(FocusEvent e) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void focusLost(FocusEvent e) {
            try {
                if (!(new Date(JDateField.this.getText()) instanceof Date)) return;
            }
            catch (Exception ex) {
                JDateField.this.requestFocus();
            }
            return;
            {
                // empty if block
            }
        }
    }

    class KeyFocus
    extends KeyAdapter {
        int mon = 0;
        int day = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;

        KeyFocus() {
        }

        public void incrementYear() {
            ++this.year;
        }

        public void incrementMonth() {
            if (this.mon < 12) {
                ++this.mon;
            } else {
                this.mon = 1;
                this.incrementYear();
            }
        }

        public void incrementDay() {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(this.year, this.mon - 1, this.day);
            int noofdays = ((Calendar)calendar).getActualMaximum(5);
            if (this.day < noofdays) {
                ++this.day;
            } else {
                this.day = 1;
                this.incrementMonth();
            }
        }

        public void incrementHour() {
            if (this.hour < 23) {
                ++this.hour;
            } else {
                this.hour = 0;
                this.incrementDay();
            }
        }

        public void incrementMinute() {
            if (this.minute < 59) {
                ++this.minute;
            } else {
                this.minute = 0;
                this.incrementHour();
            }
        }

        public void incrementSecond() {
            if (this.second < 59) {
                ++this.second;
            } else {
                this.second = 0;
                this.incrementMinute();
            }
        }

        public void parseDate(String datetime) {
            this.mon = Integer.parseInt(datetime.substring(0, 2));
            this.day = Integer.parseInt(datetime.substring(3, 5));
            this.year = Integer.parseInt(datetime.substring(6, 10));
            this.hour = Integer.parseInt(datetime.substring(11, 13));
            this.minute = Integer.parseInt(datetime.substring(14, 16));
            this.second = Integer.parseInt(datetime.substring(17, 19));
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                String datetime = JDateField.this.getText();
                this.parseDate(datetime);
                int pos = JDateField.this.getCaretPosition();
                if (pos < 3) {
                    this.incrementMonth();
                } else if (pos < 6) {
                    this.incrementDay();
                } else if (pos < 11) {
                    this.incrementYear();
                } else if (pos < 14) {
                    this.incrementHour();
                } else if (pos < 17) {
                    this.incrementMinute();
                } else if (pos < 20) {
                    this.incrementSecond();
                }
                JDateField.this.setText(this.concate(this.mon) + "/" + this.concate(this.day) + "/" + this.concate(this.year) + " " + this.concate(this.hour) + ":" + this.concate(this.minute) + ":" + this.concate(this.second));
                JDateField.this.setCaretPosition(pos);
            } else if (e.getKeyCode() == 40) {
                String datetime = JDateField.this.getText();
                this.parseDate(datetime);
                int pos = JDateField.this.getCaretPosition();
                if (pos < 3) {
                    this.decrementMonth();
                } else if (pos < 6) {
                    this.decrementDay();
                } else if (pos < 11) {
                    this.decrementYear();
                } else if (pos < 14) {
                    this.decrementHour();
                } else if (pos < 17) {
                    this.decrementMinute();
                } else if (pos < 20) {
                    this.decrementSecond();
                }
                JDateField.this.setText(this.concate(this.mon) + "/" + this.concate(this.day) + "/" + this.concate(this.year) + " " + this.concate(this.hour) + ":" + this.concate(this.minute) + ":" + this.concate(this.second));
                JDateField.this.setCaretPosition(pos);
            }
        }

        public void decrementYear() {
            --this.year;
        }

        public void decrementMonth() {
            if (this.mon > 1) {
                --this.mon;
            } else {
                this.mon = 12;
                this.decrementYear();
            }
        }

        public void decrementDay() {
            GregorianCalendar calendar = new GregorianCalendar();
            if (this.day > 1) {
                --this.day;
            } else {
                int noofdays;
                if (this.mon == 1) {
                    calendar.set(this.year, 11, this.day);
                } else {
                    calendar.set(this.year, this.mon - 2, this.day);
                }
                this.day = noofdays = ((Calendar)calendar).getActualMaximum(5);
                this.decrementMonth();
            }
        }

        public void decrementHour() {
            if (this.hour > 0) {
                --this.hour;
            } else {
                this.hour = 23;
                this.decrementDay();
            }
        }

        public void decrementMinute() {
            if (this.minute > 0) {
                --this.minute;
            } else {
                this.minute = 59;
                this.decrementHour();
            }
        }

        public void decrementSecond() {
            if (this.second > 0) {
                --this.second;
            } else {
                this.second = 59;
                this.decrementMinute();
            }
        }

        public String concate(int number) {
            String value = String.valueOf(number).length() == 1 ? "0" + number : String.valueOf(number);
            return value;
        }
    }
}

