/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.collections.Data;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PowerTableModel
extends DefaultTableModel {
    private static Logger log = LoggingManager.getLoggerForClass();
    Data model = new Data();
    Class[] columnClasses;
    static /* synthetic */ Class class$java$lang$String;

    public PowerTableModel(String[] headers, Class[] cc) {
        this.model.setHeaders(headers);
        this.columnClasses = cc;
    }

    public PowerTableModel() {
    }

    public void setRowValues(int row, Object[] values) {
        this.model.setCurrentPos(row);
        int i = 0;
        while (i < values.length) {
            this.model.addColumnValue(this.model.getHeaders()[i], values[i]);
            ++i;
        }
    }

    public Data getData() {
        return this.model;
    }

    public void addNewColumn(String colName, Class colClass) {
        this.model.addHeader(colName);
        Class[] newClasses = new Class[this.columnClasses.length + 1];
        System.arraycopy(this.columnClasses, 0, newClasses, 0, this.columnClasses.length);
        newClasses[newClasses.length - 1] = colClass;
        this.columnClasses = newClasses;
        Object defaultValue = this.createDefaultValue(this.columnClasses.length - 1);
        this.model.setColumnData(colName, defaultValue);
        this.fireTableStructureChanged();
    }

    public void removeRow(int row) {
        log.debug("remove row: " + row);
        if (this.model.size() > row) {
            log.debug("Calling remove row on Data");
            this.model.removeRow(row);
        }
    }

    public void removeColumn(int col) {
        this.model.removeColumn(col);
        this.fireTableStructureChanged();
    }

    public void setColumnData(int col, List data) {
        this.model.setColumnData(col, data);
    }

    public List getColumnData(String colName) {
        return this.model.getColumnAsObjectArray(colName);
    }

    public void clearData() {
        String[] headers = this.model.getHeaders();
        this.model = new Data();
        this.model.setHeaders(headers);
        this.fireTableDataChanged();
    }

    public void addRow(Object[] data) {
        this.model.setCurrentPos(this.model.size());
        int i = 0;
        while (i < data.length) {
            this.model.addColumnValue(this.model.getHeaders()[i], data[i]);
            ++i;
        }
    }

    public void addNewRow() {
        this.addRow(this.createDefaultRow());
    }

    private Object[] createDefaultRow() {
        Object[] rowData = new Object[this.getColumnCount()];
        int i = 0;
        while (i < rowData.length) {
            rowData[i] = this.createDefaultValue(i);
            ++i;
        }
        return rowData;
    }

    public Object[] getRowData(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        int i = 0;
        while (i < rowData.length) {
            rowData[i] = this.model.getColumnValue(i, row);
            ++i;
        }
        return rowData;
    }

    private Object createDefaultValue(int i) {
        Class colClass = this.getColumnClass(i);
        try {
            return colClass.newInstance();
        }
        catch (Exception e) {
            try {
                Constructor constr = colClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PowerTableModel.class$("java.lang.String")) : class$java$lang$String);
                return constr.newInstance("");
            }
            catch (Exception err) {
                try {
                    Constructor constr = colClass.getConstructor(Integer.TYPE);
                    return constr.newInstance(new Integer(0));
                }
                catch (Exception err2) {
                    try {
                        Constructor constr = colClass.getConstructor(Long.TYPE);
                        return constr.newInstance(new Long(0L));
                    }
                    catch (Exception err3) {
                        try {
                            Constructor constr = colClass.getConstructor(Boolean.TYPE);
                            return constr.newInstance(new Boolean(false));
                        }
                        catch (Exception err4) {
                            try {
                                Constructor constr = colClass.getConstructor(Float.TYPE);
                                return constr.newInstance(new Float(0.0f));
                            }
                            catch (Exception err5) {
                                try {
                                    Constructor constr = colClass.getConstructor(Double.TYPE);
                                    return constr.newInstance(new Double(0.0));
                                }
                                catch (Exception err6) {
                                    try {
                                        Constructor constr = colClass.getConstructor(Character.TYPE);
                                        return constr.newInstance(new Character(' '));
                                    }
                                    catch (Exception err7) {
                                        try {
                                            Constructor constr = colClass.getConstructor(Byte.TYPE);
                                            return constr.newInstance(new Byte(-128));
                                        }
                                        catch (Exception err8) {
                                            try {
                                                Constructor constr = colClass.getConstructor(Short.TYPE);
                                                return constr.newInstance(new Short(Short.MIN_VALUE));
                                            }
                                            catch (Exception err9) {
                                                return "";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.size();
    }

    public int getColumnCount() {
        return this.model.getHeaders().length;
    }

    public String getColumnName(int column) {
        return this.model.getHeaders()[column];
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int column) {
        return this.columnClasses[column];
    }

    public Object getValueAt(int row, int column) {
        return this.model.getColumnValue(column, row);
    }

    public void setValueAt(Object value, int row, int column) {
        if (row < this.model.size()) {
            this.model.setCurrentPos(row);
            this.model.addColumnValue(this.model.getHeaders()[column], value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

