/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.jmeter.reporters.graphPanel;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FileReporter
extends JPanel {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    Hashtable data = new Hashtable();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(String file) throws IOException {
        String line;
        File datafile = new File(file);
        BufferedReader reader = null;
        if (!datafile.canRead()) {
            JOptionPane.showMessageDialog(null, "The file you specified cannot be read.", "Information", 1);
            return;
        }
        reader = new BufferedReader(new FileReader(datafile));
        while ((line = reader.readLine()) != null) {
            void var4_4;
            try {
                var4_4.trim();
                if (var4_4.startsWith("#") || var4_4.length() == 0) continue;
                int splitter = var4_4.lastIndexOf(32);
                String key = var4_4.substring(0, splitter);
                int len = var4_4.length() - 1;
                Integer value = null;
                value = var4_4.charAt(len) == ',' ? new Integer(var4_4.substring(splitter + 1, len)) : new Integer(var4_4.substring(splitter + 1));
                Vector<Integer> v = this.getData(key);
                if (v == null) {
                    v = new Vector<Integer>();
                    this.data.put(key, v);
                }
                v.addElement(value);
            }
            catch (NumberFormatException nfe) {
                log.error("This line could not be parsed: " + (String)var4_4, (Throwable)nfe);
            }
            catch (Exception e) {
                log.error("This line caused a problem: " + (String)var4_4, (Throwable)e);
            }
        }
        reader.close();
        this.showPanel();
    }

    public Vector getData(String key) {
        return (Vector)this.data.get(key);
    }

    public void showPanel() {
        JFrame f = new JFrame("Data File Report");
        this.setLayout(new BorderLayout());
        graphPanel gp = new graphPanel(this.data);
        this.add((Component)gp, "Center");
        this.add((Component)gp.getStats(), "East");
        this.add((Component)gp.getLegend(), "North");
        f.setSize(500, 300);
        f.getContentPane().add(this);
        f.show();
    }
}

