/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteListenerWrapper
extends AbstractTestElement
implements SampleListener,
TestListener,
Serializable,
NoThreadClone {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    RemoteSampleListener listener;

    public RemoteListenerWrapper(RemoteSampleListener l) {
        this.listener = l;
    }

    public RemoteListenerWrapper() {
    }

    public void testStarted() {
        try {
            this.listener.testStarted();
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void testEnded() {
        try {
            this.listener.testEnded();
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void testStarted(String host) {
        try {
            this.listener.testStarted(host);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void testEnded(String host) {
        try {
            this.listener.testEnded(host);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void sampleOccurred(SampleEvent e) {
        try {
            this.listener.sampleOccurred(e);
        }
        catch (RemoteException err) {
            log.error("", (Throwable)err);
        }
    }

    public void sampleStarted(SampleEvent e) {
        try {
            this.listener.sampleStarted(e);
        }
        catch (RemoteException err) {
            log.error("", (Throwable)err);
        }
    }

    public void sampleStopped(SampleEvent e) {
        try {
            this.listener.sampleStopped(e);
        }
        catch (RemoteException err) {
            log.error("", (Throwable)err);
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }
}

