/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SampleResult
implements Serializable {
    public static final String TEXT = "text";
    public static final String BINARY = "bin";
    private byte[] responseData;
    private String responseCode;
    private String label;
    private String samplerData;
    private String threadName;
    private String responseMessage;
    private long timeStamp = 0L;
    private List assertionResults;
    private List subResults;
    private String dataType;
    private boolean success;
    private Set files;
    private String dataEncoding;
    private long time;
    private static final String TOTAL_TIME = "totalTime";
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");

    public void setMarked(String filename) {
        if (this.files == null) {
            this.files = new HashSet();
        }
        this.files.add(filename);
    }

    public boolean isMarked(String filename) {
        return this.files != null && this.files.contains(filename);
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String code) {
        this.responseCode = code;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String msg) {
        this.responseMessage = msg;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getSampleLabel() {
        return this.label;
    }

    public void setSampleLabel(String label) {
        this.label = label;
    }

    public void addAssertionResult(AssertionResult assertResult) {
        if (this.assertionResults == null) {
            this.assertionResults = new ArrayList();
        }
        this.assertionResults.add(assertResult);
    }

    public AssertionResult[] getAssertionResults() {
        if (this.assertionResults == null) {
            return null;
        }
        return this.assertionResults.toArray(new AssertionResult[0]);
    }

    public void addSubResult(SampleResult subResult) {
        if (this.subResults == null) {
            this.subResults = new ArrayList();
        }
        this.subResults.add(subResult);
    }

    public SampleResult[] getSubResults() {
        if (this.subResults == null) {
            return null;
        }
        return this.subResults.toArray(new SampleResult[0]);
    }

    public void configure(Configuration info) {
        this.setTime(info.getAttributeAsLong(TOTAL_TIME, 0L));
    }

    public void setTime(long t) {
        this.time = t;
    }

    public void setResponseData(byte[] response) {
        this.responseData = response;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public void setSamplerData(String s) {
        this.samplerData = s;
    }

    public String getSamplerData() {
        return this.samplerData;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }

    public String toString() {
        return this.getSampleLabel();
    }

    public String getDataEncoding() {
        if (this.dataEncoding != null) {
            return this.dataEncoding;
        }
        return "8859-1";
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }
}

