/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveServiceConstants;
import org.apache.jmeter.save.TestElementSaver;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public class SaveService
implements SaveServiceConstants {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.util");
    protected static final int SAVE_NO_ASSERTIONS = 0;
    protected static final int SAVE_FIRST_ASSERTION = 1;
    protected static final int SAVE_ALL_ASSERTIONS = 2;
    protected static SimpleDateFormat formatter = null;
    protected static int outputFormat = 0;
    protected static boolean printFieldNames = false;
    protected static boolean saveDataType = true;
    protected static boolean saveAssertionResultsFailureMessage = false;
    protected static boolean saveLabel = true;
    protected static boolean saveResponseCode = false;
    protected static boolean saveResponseData = false;
    protected static boolean saveResponseMessage = false;
    protected static boolean saveSuccessful = true;
    protected static boolean saveThreadName = true;
    protected static boolean saveTime = true;
    protected static String timeStampFormat = "ms";
    protected static boolean printMilliseconds = true;
    protected static String whichAssertionResults = "first";
    protected static int assertionsResultsToSave = 0;
    protected static String defaultDelimiter = ",";
    private static DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();

    protected static void readProperties() {
        Properties systemProps = System.getProperties();
        Properties props = new Properties(systemProps);
        try {
            props = JMeterUtils.getJMeterProperties();
        }
        catch (Exception e) {
            log.error("SaveService.readProperties: Problem loading properties file: ", (Throwable)e);
        }
        printFieldNames = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.print_field_names", "false"));
        saveDataType = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.data_type", "true"));
        saveLabel = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.label", "true"));
        saveResponseCode = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_code", "true"));
        saveResponseData = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_data", "false"));
        saveResponseMessage = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_message", "true"));
        saveSuccessful = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.successful", "true"));
        saveThreadName = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.thread_name", "true"));
        saveTime = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.time", "true"));
        timeStampFormat = props.getProperty("jmeter.save.saveservice.timestamp_format", "ms");
        printMilliseconds = "ms".equalsIgnoreCase(timeStampFormat);
        if (!printMilliseconds && !"none".equalsIgnoreCase(timeStampFormat) && timeStampFormat != null) {
            formatter = new SimpleDateFormat(timeStampFormat);
        }
        whichAssertionResults = props.getProperty("jmeter.save.saveservice.assertion_results", "none");
        saveAssertionResultsFailureMessage = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.assertion_results_failure_message", "false"));
        if ("none".equals(whichAssertionResults)) {
            assertionsResultsToSave = 0;
        } else if ("first".equals(whichAssertionResults)) {
            assertionsResultsToSave = 1;
        } else if ("all".equals(whichAssertionResults)) {
            assertionsResultsToSave = 2;
        }
        String howToSave = props.getProperty("jmeter.save.saveservice.output_format", "xml");
        outputFormat = "csv".equals(howToSave) ? 1 : 0;
        defaultDelimiter = props.getProperty("jmeter.save.saveservice.default_delimiter", ",");
    }

    public static int getOutputFormat() {
        return outputFormat;
    }

    public static boolean getPrintFieldNames() {
        return printFieldNames;
    }

    public static String printableFieldNamesToString() {
        int delSize;
        StringBuffer text = new StringBuffer();
        if (printMilliseconds || formatter != null) {
            text.append("timeStamp");
            text.append(defaultDelimiter);
        }
        if (saveTime) {
            text.append("time");
            text.append(defaultDelimiter);
        }
        if (saveLabel) {
            text.append("label");
            text.append(defaultDelimiter);
        }
        if (saveResponseCode) {
            text.append("responseCode");
            text.append(defaultDelimiter);
        }
        if (saveResponseMessage) {
            text.append("responseMessage");
            text.append(defaultDelimiter);
        }
        if (saveThreadName) {
            text.append("threadName");
            text.append(defaultDelimiter);
        }
        if (saveDataType) {
            text.append("dataType");
            text.append(defaultDelimiter);
        }
        if (saveSuccessful) {
            text.append("success");
            text.append(defaultDelimiter);
        }
        if (saveAssertionResultsFailureMessage) {
            text.append("failureMessage");
            text.append(defaultDelimiter);
        }
        String resultString = null;
        int size = text.length();
        resultString = size >= (delSize = defaultDelimiter.length()) ? text.substring(0, size - delSize) : text.toString();
        return resultString;
    }

    public static void saveSubTree(HashTree subTree, OutputStream writer) throws IOException {
        Configuration config = (Configuration)SaveService.getConfigsFromTree(subTree).get(0);
        DefaultConfigurationSerializer saver = new DefaultConfigurationSerializer();
        saver.setIndent(true);
        try {
            saver.serialize(writer, config);
        }
        catch (SAXException e) {
            throw new IOException("SAX implementation problem");
        }
        catch (ConfigurationException e) {
            throw new IOException("Problem using Avalon Configuration tools");
        }
    }

    public static SampleResult getSampleResult(Configuration config) {
        SampleResult result = new SampleResult();
        result.setThreadName(config.getAttribute("threadName", ""));
        result.setDataType(config.getAttribute("dataType", ""));
        result.setResponseCode(config.getAttribute("responseCode", ""));
        result.setResponseMessage(config.getAttribute("responseMessage", ""));
        result.setTime(config.getAttributeAsLong("time", 0L));
        result.setTimeStamp(config.getAttributeAsLong("timeStamp", 0L));
        result.setSuccessful(config.getAttributeAsBoolean("success", false));
        result.setSampleLabel(config.getAttribute("label", ""));
        result.setResponseData(SaveService.getBinaryData(config.getChild("binary")));
        Configuration[] subResults = config.getChildren("sampleResult");
        int i = 0;
        while (i < subResults.length) {
            result.addSubResult(SaveService.getSampleResult(subResults[i]));
            ++i;
        }
        Configuration[] assResults = config.getChildren("assertionResult");
        int i2 = 0;
        while (i2 < assResults.length) {
            result.addAssertionResult(SaveService.getAssertionResult(assResults[i2]));
            ++i2;
        }
        Configuration[] samplerData = config.getChildren("property");
        int i3 = 0;
        while (i3 < samplerData.length) {
            result.setSamplerData(samplerData[i3].getValue(""));
            ++i3;
        }
        return result;
    }

    private static List getConfigsFromTree(HashTree subTree) {
        Iterator iter = subTree.list().iterator();
        LinkedList<DefaultConfiguration> configs = new LinkedList<DefaultConfiguration>();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            DefaultConfiguration config = new DefaultConfiguration("node", "node");
            config.addChild(SaveService.getConfigForTestElement(null, item));
            List configList = SaveService.getConfigsFromTree(subTree.getTree((Object)item));
            Iterator iter2 = configList.iterator();
            while (iter2.hasNext()) {
                config.addChild((Configuration)iter2.next());
            }
            configs.add(config);
        }
        return configs;
    }

    public static Configuration getConfiguration(byte[] bin) {
        DefaultConfiguration config = new DefaultConfiguration("binary", "JMeter Save Service");
        try {
            config.setValue(new String(bin, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        return config;
    }

    public static byte[] getBinaryData(Configuration config) {
        if (config == null) {
            return new byte[0];
        }
        try {
            return config.getValue("").getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static AssertionResult getAssertionResult(Configuration config) {
        AssertionResult result = new AssertionResult();
        result.setError(config.getAttributeAsBoolean("error", false));
        result.setFailure(config.getAttributeAsBoolean("failure", false));
        result.setFailureMessage(config.getAttribute("failureMessage", ""));
        return result;
    }

    public static Configuration getConfiguration(AssertionResult assResult) {
        DefaultConfiguration config = new DefaultConfiguration("assertionResult", "JMeter Save Service");
        config.setAttribute("failureMessage", assResult.getFailureMessage());
        config.setAttribute("error", "" + assResult.isError());
        config.setAttribute("failure", "" + assResult.isFailure());
        return config;
    }

    public static Configuration getConfiguration(SampleResult result, boolean funcTest) {
        SampleResult[] subResults;
        DefaultConfiguration config = new DefaultConfiguration("sampleResult", "JMeter Save Service");
        if (saveTime) {
            config.setAttribute("time", "" + result.getTime());
        }
        if (saveLabel) {
            config.setAttribute("label", result.getSampleLabel());
        }
        if (saveResponseCode) {
            config.setAttribute("responseCode", result.getResponseCode());
        }
        if (saveResponseMessage) {
            config.setAttribute("responseMessage", result.getResponseMessage());
        }
        if (saveThreadName) {
            config.setAttribute("threadName", result.getThreadName());
        }
        if (saveDataType) {
            config.setAttribute("dataType", result.getDataType());
        }
        if (printMilliseconds) {
            config.setAttribute("timeStamp", "" + result.getTimeStamp());
        } else if (formatter != null) {
            String stamp = formatter.format(new Date(result.getTimeStamp()));
            config.setAttribute("timeStamp", stamp);
        }
        if (saveSuccessful) {
            config.setAttribute("success", new Boolean(result.isSuccessful()).toString());
        }
        if ((subResults = result.getSubResults()) != null) {
            int i = 0;
            while (i < subResults.length) {
                config.addChild(SaveService.getConfiguration(subResults[i], funcTest));
                ++i;
            }
        }
        AssertionResult[] assResults = result.getAssertionResults();
        if (funcTest) {
            config.addChild(SaveService.createConfigForString("samplerData", result.getSamplerData()));
            if (assResults != null) {
                int i = 0;
                while (i < assResults.length) {
                    config.addChild(SaveService.getConfiguration(assResults[i]));
                    ++i;
                }
            }
            config.addChild(SaveService.getConfiguration(result.getResponseData()));
        } else {
            if (assertionsResultsToSave == 2) {
                config.addChild(SaveService.createConfigForString("samplerData", result.getSamplerData()));
                if (assResults != null) {
                    int i = 0;
                    while (i < assResults.length) {
                        config.addChild(SaveService.getConfiguration(assResults[i]));
                        ++i;
                    }
                }
            } else if (assertionsResultsToSave == 1 && assResults != null && assResults.length > 0) {
                config.addChild(SaveService.getConfiguration(assResults[0]));
            }
            if (saveResponseData) {
                config.addChild(SaveService.getConfiguration(result.getResponseData()));
            }
        }
        return config;
    }

    public static String resultToDelimitedString(SampleResult sample) {
        return SaveService.resultToDelimitedString(sample, defaultDelimiter);
    }

    public static String resultToDelimitedString(SampleResult sample, String delimiter) {
        int delSize;
        StringBuffer text = new StringBuffer();
        if (printMilliseconds) {
            text.append("" + sample.getTimeStamp());
            text.append(delimiter);
        } else if (formatter != null) {
            String stamp = formatter.format(new Date(sample.getTimeStamp()));
            text.append(stamp);
            text.append(delimiter);
        }
        if (saveTime) {
            text.append("" + sample.getTime());
            text.append(delimiter);
        }
        if (saveLabel) {
            text.append(sample.getSampleLabel());
            text.append(delimiter);
        }
        if (saveResponseCode) {
            text.append(sample.getResponseCode());
            text.append(delimiter);
        }
        if (saveResponseMessage) {
            text.append(sample.getResponseMessage());
            text.append(delimiter);
        }
        if (saveThreadName) {
            text.append(sample.getThreadName());
            text.append(delimiter);
        }
        if (saveDataType) {
            text.append(sample.getDataType());
            text.append(delimiter);
        }
        if (saveSuccessful) {
            text.append("" + sample.isSuccessful());
            text.append(delimiter);
        }
        if (saveAssertionResultsFailureMessage) {
            String message = null;
            AssertionResult[] results = sample.getAssertionResults();
            if (results != null && results.length > 0) {
                message = results[0].getFailureMessage();
            }
            if (message == null) {
                message = "";
            }
            text.append(message);
            text.append(delimiter);
        }
        String resultString = null;
        int size = text.length();
        resultString = size >= (delSize = delimiter.length()) ? text.substring(0, size - delSize) : text.toString();
        return resultString;
    }

    public static Configuration getConfigForTestElement(String named, TestElement item) {
        TestElementSaver saver = new TestElementSaver(named);
        item.traverse(saver);
        Configuration config = saver.getConfiguration();
        return config;
    }

    private static Configuration createConfigForCollection(String propertyName, Collection list) {
        DefaultConfiguration config = new DefaultConfiguration("collection", "collection");
        if (propertyName != null) {
            config.setAttribute("name", propertyName);
        }
        config.setAttribute("class", list.getClass().getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof TestElement) {
                config.addChild(SaveService.getConfigForTestElement(null, (TestElement)item));
                continue;
            }
            if (item instanceof Collection) {
                config.addChild(SaveService.createConfigForCollection(null, (Collection)item));
                continue;
            }
            config.addChild(SaveService.createConfigForString(item.toString()));
        }
        return config;
    }

    private static Configuration createConfigForString(String value) {
        DefaultConfiguration config = new DefaultConfiguration("string", "string");
        config.setValue(value);
        config.setAttribute("xml:space", "preserve");
        return config;
    }

    private static Configuration createConfigForString(String name, String value) {
        if (value == null) {
            value = "";
        }
        DefaultConfiguration config = new DefaultConfiguration("property", "property");
        config.setAttribute("name", name);
        config.setValue(value);
        config.setAttribute("xml:space", "preserve");
        return config;
    }

    public static synchronized HashTree loadSubTree(InputStream in) throws IOException {
        try {
            Configuration config = builder.build(in);
            HashTree loadedTree = SaveService.generateNode(config);
            return loadedTree;
        }
        catch (ConfigurationException e) {
            String message = "Problem loading using Avalon Configuration tools";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
        catch (SAXException e) {
            String message = "Problem with SAX implementation";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
    }

    public static TestElement createTestElement(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        TestElement element = null;
        element = (TestElement)Class.forName(NameUpdater.getCurrentName(config.getAttribute("class"))).newInstance();
        Configuration[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals("property")) {
                try {
                    element.setProperty(SaveService.createProperty(children[i]));
                }
                catch (Exception ex) {
                    log.error("Problem loading property", (Throwable)ex);
                    element.setProperty(children[i].getAttribute("name"), "");
                }
            } else if (children[i].getName().equals("testelement")) {
                element.setProperty(new TestElementProperty(children[i].getAttribute("name", ""), SaveService.createTestElement(children[i])));
            } else if (children[i].getName().equals("collection")) {
                element.setProperty(new CollectionProperty(children[i].getAttribute("name", ""), SaveService.createCollection(children[i])));
            } else if (children[i].getName().equals("map")) {
                element.setProperty(new MapProperty(children[i].getAttribute("name", ""), SaveService.createMap(children[i])));
            }
            ++i;
        }
        return element;
    }

    private static Collection createCollection(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Collection coll = (Collection)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        int i = 0;
        while (i < items.length) {
            if (items[i].getName().equals("property")) {
                coll.add(SaveService.createProperty(items[i]));
            } else if (items[i].getName().equals("testelement")) {
                coll.add(new TestElementProperty(items[i].getAttribute("name", ""), SaveService.createTestElement(items[i])));
            } else if (items[i].getName().equals("collection")) {
                coll.add(new CollectionProperty(items[i].getAttribute("name", ""), SaveService.createCollection(items[i])));
            } else if (items[i].getName().equals("string")) {
                coll.add(SaveService.createProperty(items[i]));
            } else if (items[i].getName().equals("map")) {
                coll.add(new MapProperty(items[i].getAttribute("name", ""), SaveService.createMap(items[i])));
            }
            ++i;
        }
        return coll;
    }

    private static JMeterProperty createProperty(Configuration config) throws ConfigurationException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String value = config.getValue("");
        JMeterProperty prop = (JMeterProperty)Class.forName(config.getAttribute("propType", "org.apache.jmeter.testelement.property.StringProperty")).newInstance();
        prop.setName(config.getAttribute("name", value));
        prop.setObjectValue(value);
        return prop;
    }

    private static Map createMap(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Map map = (Map)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        int i = 0;
        while (i < items.length) {
            if (items[i].getName().equals("property")) {
                JMeterProperty prop = SaveService.createProperty(items[i]);
                map.put(prop.getName(), prop);
            } else if (items[i].getName().equals("testelement")) {
                map.put(items[i].getAttribute("name", ""), new TestElementProperty(items[i].getAttribute("name", ""), SaveService.createTestElement(items[i])));
            } else if (items[i].getName().equals("collection")) {
                map.put(items[i].getAttribute("name"), new CollectionProperty(items[i].getAttribute("name", ""), SaveService.createCollection(items[i])));
            } else if (items[i].getName().equals("map")) {
                map.put(items[i].getAttribute("name", ""), new MapProperty(items[i].getAttribute("name", ""), SaveService.createMap(items[i])));
            }
            ++i;
        }
        return map;
    }

    private static HashTree generateNode(Configuration config) {
        TestElement element = null;
        try {
            element = SaveService.createTestElement(config.getChild("testelement"));
        }
        catch (Exception e) {
            log.error("Problem loading part of file", (Throwable)e);
            return null;
        }
        ListedHashTree subTree = new ListedHashTree((Object)element);
        Configuration[] subNodes = config.getChildren("node");
        int i = 0;
        while (i < subNodes.length) {
            HashTree t = SaveService.generateNode(subNodes[i]);
            if (t != null) {
                subTree.add((Object)element, t);
            }
            ++i;
        }
        return subTree;
    }

    static {
        SaveService.readProperties();
    }

    public static class Test
    extends TestCase {
        private static final String[] FILES = new String[]{"AssertionTestPlan.jmx", "AuthManagerTestPlan.jmx", "HeaderManagerTestPlan.jmx", "InterleaveTestPlan2.jmx", "InterleaveTestPlan.jmx", "LoopTestPlan.jmx", "Modification Manager.jmx", "OnceOnlyTestPlan.jmx", "proxy.jmx", "ProxyServerTestPlan.jmx", "SimpleTestPlan.jmx"};

        public Test(String name) {
            super(name);
        }

        public void setUp() {
        }

        public void testLoadAndSave() throws IOException {
            byte[] original = new byte[1000000];
            int i = 0;
            while (i < FILES.length) {
                InputStream in = new FileInputStream(new File("testfiles/" + FILES[i]));
                int len = in.read(original);
                in.close();
                in = new ByteArrayInputStream(original, 0, len);
                HashTree tree = SaveService.loadSubTree(in);
                in.close();
                ByteArrayOutputStream out = new ByteArrayOutputStream(1000000);
                SaveService.saveSubTree(tree, out);
                out.close();
                if (len != out.size()) {
                    Assert.fail((String)("Loading file bin/testfiles/" + FILES[i] + " and " + "saving it back changes its contents."));
                }
                ++i;
            }
        }
    }
}

