/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementTraverser;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractTestElement
implements TestElement,
Serializable {
    protected static Logger log = LoggingManager.getLoggerForClass();
    private Map propMap = Collections.synchronizedMap(new HashMap());
    private boolean runningVersion = false;

    public Object clone() {
        TestElement clonedElement = null;
        try {
            clonedElement = (TestElement)this.getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        PropertyIterator iter = this.propertyIterator();
        while (iter.hasNext()) {
            clonedElement.setProperty((JMeterProperty)iter.next().clone());
        }
        clonedElement.setRunningVersion(this.runningVersion);
        return clonedElement;
    }

    public void clear() {
        this.propMap.clear();
    }

    public void removeProperty(String key) {
        this.propMap.remove(key);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTestElement) {
            return ((AbstractTestElement)o).propMap.equals(this.propMap);
        }
        return false;
    }

    public void addTestElement(TestElement el) {
        this.mergeIn(el);
    }

    public void setName(String name) {
        this.setProperty(new StringProperty("TestElement.name", name));
    }

    public String getName() {
        return this.getProperty("TestElement.name").getStringValue();
    }

    public JMeterProperty getProperty(String key) {
        JMeterProperty prop = (JMeterProperty)this.propMap.get(key);
        if (prop == null) {
            prop = new NullProperty(key);
        }
        return prop;
    }

    public void traverse(TestElementTraverser traverser) {
        PropertyIterator iter = this.propertyIterator();
        traverser.startTestElement(this);
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
        traverser.endTestElement(this);
    }

    protected void traverseProperty(TestElementTraverser traverser, JMeterProperty value) {
        traverser.startProperty(value);
        if (value instanceof TestElementProperty) {
            ((TestElement)value.getObjectValue()).traverse(traverser);
        } else if (value instanceof CollectionProperty) {
            this.traverseCollection((CollectionProperty)value, traverser);
        } else if (value instanceof MapProperty) {
            this.traverseMap((MapProperty)value, traverser);
        }
        traverser.endProperty(value);
    }

    protected void traverseMap(MapProperty map, TestElementTraverser traverser) {
        PropertyIterator iter = map.valueIterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    protected void traverseCollection(CollectionProperty col, TestElementTraverser traverser) {
        PropertyIterator iter = col.iterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    public int getPropertyAsInt(String key) {
        return this.getProperty(key).getIntValue();
    }

    public boolean getPropertyAsBoolean(String key) {
        return this.getProperty(key).getBooleanValue();
    }

    public float getPropertyAsFloat(String key) {
        return this.getProperty(key).getFloatValue();
    }

    public long getPropertyAsLong(String key) {
        return this.getProperty(key).getLongValue();
    }

    public double getPropertyAsDouble(String key) {
        return this.getProperty(key).getDoubleValue();
    }

    public String getPropertyAsString(String key) {
        return this.getProperty(key).getStringValue();
    }

    protected void addProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            property.setTemporary(true, this);
        } else {
            property.clearTemporary(this);
        }
        JMeterProperty prop = this.getProperty(property.getName());
        if (prop instanceof NullProperty || prop instanceof StringProperty && prop.getStringValue().equals("")) {
            this.propMap.put(property.getName(), property);
        } else {
            prop.mergeIn(property);
        }
    }

    protected void logProperties() {
        if (log.isDebugEnabled()) {
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                JMeterProperty prop = iter.next();
                log.debug("Property " + prop.getName() + " is temp? " + prop.isTemporary(this) + " and is a " + prop.getObjectValue());
            }
        }
    }

    public void setProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            if (this.getProperty(property.getName()) instanceof NullProperty) {
                this.addProperty(property);
            } else {
                this.getProperty(property.getName()).setObjectValue(property.getObjectValue());
            }
        } else {
            this.propMap.put(property.getName(), property);
        }
    }

    public void setProperty(String name, String value) {
        this.setProperty(new StringProperty(name, value));
    }

    public PropertyIterator propertyIterator() {
        return new PropertyIteratorImpl(this.propMap.values());
    }

    protected void mergeIn(TestElement element) {
        PropertyIterator iter = element.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            this.addProperty(prop);
        }
    }

    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
        PropertyIterator iter = this.propertyIterator();
        while (iter.hasNext()) {
            iter.next().setRunningVersion(runningVersion);
        }
    }

    public void recoverRunningVersion() {
        PropertyIterator iter = this.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            if (prop.isTemporary(this)) {
                iter.remove();
                prop.clearTemporary(this);
                continue;
            }
            prop.recoverRunningVersion(this);
        }
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        return null;
    }
}

