/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractProperty
implements JMeterProperty {
    protected static Logger log = LoggingManager.getLoggerForClass();
    private String name;
    private boolean runningVersion = false;
    private Map ownerMap;

    public AbstractProperty(String name) {
        this.name = name;
    }

    public AbstractProperty() {
        this("");
    }

    protected boolean isEqualType(JMeterProperty prop) {
        return this.getClass().equals(prop.getClass());
    }

    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
    }

    public boolean isTemporary(TestElement owner) {
        if (this.ownerMap == null) {
            return false;
        }
        boolean[] temp = (boolean[])this.ownerMap.get(owner);
        if (temp == null) {
            return false;
        }
        return temp[0];
    }

    public void mergeIn(JMeterProperty prop) {
    }

    public void setTemporary(boolean temporary, TestElement owner) {
        boolean[] temp;
        if (this.ownerMap == null) {
            this.ownerMap = new HashMap();
        }
        if ((temp = (boolean[])this.ownerMap.get(owner)) != null) {
            temp[0] = temporary;
        } else {
            temp = new boolean[]{temporary};
            this.ownerMap.put(owner, temp);
        }
    }

    public void clearTemporary(TestElement owner) {
        if (this.ownerMap == null) {
            return;
        }
        this.ownerMap.remove(owner);
    }

    public Object clone() {
        try {
            AbstractProperty prop = (AbstractProperty)this.getClass().newInstance();
            prop.name = this.name;
            prop.runningVersion = this.runningVersion;
            prop.ownerMap = this.ownerMap;
            return prop;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public int getIntValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLongValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public double getDoubleValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0;
        }
    }

    public void recoverRunningVersion(TestElement owner) {
    }

    public float getFloatValue() {
        String val = this.getStringValue();
        if (val == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0f;
        }
    }

    public boolean getBooleanValue() {
        String val = this.getStringValue();
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof JMeterProperty) {
            String val = this.getStringValue();
            if (val == null) {
                log.warn("Warning: Unexpected null value for property: " + this.name);
                if (((JMeterProperty)arg0).getStringValue() == null) {
                    return 0;
                }
                return -1;
            }
            return this.getStringValue().compareTo(((JMeterProperty)arg0).getStringValue());
        }
        return -1;
    }

    protected Class getPropertyType() {
        return this.getClass();
    }

    protected JMeterProperty getBlankProperty() {
        try {
            JMeterProperty prop = (JMeterProperty)this.getPropertyType().newInstance();
            if (prop instanceof NullProperty) {
                return new StringProperty();
            }
            return prop;
        }
        catch (Exception e) {
            return new StringProperty();
        }
    }

    protected Collection normalizeList(Collection coll) {
        Iterator iter = coll.iterator();
        Collection newColl = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            if (newColl == null) {
                try {
                    newColl = (Collection)coll.getClass().newInstance();
                }
                catch (Exception e) {
                    log.error("Bad collection", (Throwable)e);
                }
            }
            newColl.add(this.convertObject(item));
        }
        if (newColl != null) {
            return newColl;
        }
        return coll;
    }

    protected Map normalizeMap(Map coll) {
        Iterator iter = coll.keySet().iterator();
        Map newColl = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            Object prop = coll.get(item);
            if (newColl == null) {
                try {
                    newColl = (Map)coll.getClass().newInstance();
                }
                catch (Exception e) {
                    log.error("Bad collection", (Throwable)e);
                }
            }
            newColl.put(item, this.convertObject(prop));
        }
        if (newColl != null) {
            return newColl;
        }
        return coll;
    }

    protected JMeterProperty convertObject(Object item) {
        if (item instanceof JMeterProperty) {
            return (JMeterProperty)item;
        }
        if (item instanceof TestElement) {
            return new TestElementProperty(((TestElement)item).getPropertyAsString("TestElement.name"), (TestElement)item);
        }
        if (item instanceof Collection) {
            return new CollectionProperty("" + item.hashCode(), (Collection)item);
        }
        if (item instanceof Map) {
            return new MapProperty("" + item.hashCode(), (Map)item);
        }
        JMeterProperty prop = this.getBlankProperty();
        prop.setName(item.toString());
        prop.setObjectValue(item);
        return prop;
    }

    public String toString() {
        return this.getStringValue();
    }
}

