/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.FunctionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;

public class CollectionProperty
extends MultiProperty {
    protected Collection value;
    private Collection savedValue;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$property$NullProperty;

    public CollectionProperty(String name, Collection value) {
        super(name);
        this.value = this.normalizeList(value);
    }

    public CollectionProperty() {
        this.value = new ArrayList();
    }

    public boolean equals(Object o) {
        if (o instanceof CollectionProperty && this.value != null) {
            return this.value.equals(((JMeterProperty)o).getObjectValue());
        }
        return false;
    }

    public void remove(String prop) {
        PropertyIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getName().equals(prop)) continue;
            iter.remove();
        }
    }

    public void set(int index, String prop) {
        if (this.value instanceof List) {
            ((List)this.value).set(index, new StringProperty(prop, prop));
        }
    }

    public void set(int index, JMeterProperty prop) {
        if (this.value instanceof List) {
            ((List)this.value).set(index, prop);
        }
    }

    public JMeterProperty get(int row) {
        if (this.value instanceof List) {
            return (JMeterProperty)((List)this.value).get(row);
        }
        return null;
    }

    public void remove(int index) {
        if (this.value instanceof List) {
            ((List)this.value).remove(index);
        }
    }

    public void setObjectValue(Object v) {
        if (v instanceof Collection) {
            this.setCollection((Collection)v);
        }
    }

    public PropertyIterator iterator() {
        return new PropertyIteratorImpl(this.value);
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public Object getObjectValue() {
        return this.value;
    }

    public int size() {
        return this.value.size();
    }

    public Object clone() {
        CollectionProperty prop = (CollectionProperty)super.clone();
        prop.value = this.cloneCollection();
        return prop;
    }

    private Collection cloneCollection() {
        try {
            Collection newCol = (Collection)this.value.getClass().newInstance();
            PropertyIterator iter = this.iterator();
            while (iter.hasNext()) {
                newCol.add(iter.next().clone());
            }
            return newCol;
        }
        catch (Exception e) {
            AbstractProperty.log.error("Couldn't clone collection", (Throwable)e);
            return this.value;
        }
    }

    public void setCollection(Collection coll) {
        this.value = this.normalizeList(coll);
    }

    public void clear() {
        this.value.clear();
    }

    public void addProperty(JMeterProperty prop) {
        this.value.add(prop);
    }

    public void addItem(Object item) {
        this.addProperty(this.convertObject(item));
    }

    protected Class getPropertyType() {
        if (this.value.size() > 0) {
            return this.value.iterator().next().getClass();
        }
        return class$org$apache$jmeter$testelement$property$NullProperty == null ? (class$org$apache$jmeter$testelement$property$NullProperty = CollectionProperty.class$("org.apache.jmeter.testelement.property.NullProperty")) : class$org$apache$jmeter$testelement$property$NullProperty;
    }

    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.recoverRunningVersionOfSubElements(owner);
    }

    public void setRunningVersion(boolean running) {
        super.setRunningVersion(running);
        this.savedValue = running ? this.value : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testAddingProperties() throws Exception {
            CollectionProperty coll = new CollectionProperty();
            coll.addItem("joe");
            coll.addProperty(new FunctionProperty());
            Assert.assertEquals((Object)"joe", (Object)coll.get(0).getName());
            Assert.assertEquals((Object)"org.apache.jmeter.testelement.property.FunctionProperty", (Object)coll.get(1).getClass().getName());
        }
    }
}

