/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.property.NumberProperty;

public class DoubleProperty
extends NumberProperty {
    double value;

    public DoubleProperty(String name, double value) {
        super(name);
        this.value = value;
    }

    public DoubleProperty() {
    }

    public void setValue(float value) {
        this.value = value;
    }

    protected void setNumberValue(Number n) {
        this.value = n.doubleValue();
    }

    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Double.parseDouble(n);
    }

    public String getStringValue() {
        return Double.toString(this.value);
    }

    public Object getObjectValue() {
        return new Double(this.value);
    }

    public Object clone() {
        DoubleProperty prop = (DoubleProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public boolean getBooleanValue() {
        return this.value > 0.0;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return (float)this.value;
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }
}

