/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.property.NumberProperty;

public class LongProperty
extends NumberProperty {
    long value;

    public LongProperty(String name, long value) {
        super(name);
        this.value = value;
    }

    public LongProperty() {
    }

    public void setValue(int value) {
        this.value = value;
    }

    protected void setNumberValue(Number n) {
        this.value = n.longValue();
    }

    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Long.parseLong(n);
    }

    public String getStringValue() {
        return Long.toString(this.value);
    }

    public Object getObjectValue() {
        return new Long(this.value);
    }

    public Object clone() {
        LongProperty prop = (LongProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public boolean getBooleanValue() {
        return this.getLongValue() > 0L;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public long getLongValue() {
        return this.value;
    }
}

