/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;

public class StringProperty
extends AbstractProperty {
    String value;
    String savedValue;

    public StringProperty(String name, String value) {
        super(name);
        this.value = value;
    }

    public StringProperty() {
    }

    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        this.savedValue = runningVersion ? this.value : null;
    }

    public void setObjectValue(Object v) {
        this.value = v.toString();
    }

    public String getStringValue() {
        return this.value;
    }

    public Object getObjectValue() {
        return this.value;
    }

    public Object clone() {
        StringProperty prop = (StringProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        super.recoverRunningVersion(owner);
    }
}

