/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterThread
implements Runnable,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    static Map samplers = new HashMap();
    int initialDelay = 0;
    Controller controller;
    private boolean running;
    HashTree testTree;
    TestCompiler compiler;
    JMeterThreadMonitor monitor;
    String threadName;
    JMeterContext threadContext;
    JMeterVariables threadVars;
    Collection testListeners;
    ListenerNotifier notifier;
    int threadNum = 0;
    long startTime = 0L;
    long endTime = 0L;
    private boolean scheduler = false;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestListener;

    public JMeterThread() {
    }

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree, this.threadVars);
        this.controller = (Controller)this.testTree.getArray()[0];
        SearchByClass threadListenerSearcher = new SearchByClass(class$org$apache$jmeter$testelement$TestListener == null ? (class$org$apache$jmeter$testelement$TestListener = JMeterThread.class$("org.apache.jmeter.testelement.TestListener")) : class$org$apache$jmeter$testelement$TestListener);
        test.traverse((HashTreeTraverser)threadListenerSearcher);
        this.testListeners = threadListenerSearcher.getSearchResults();
        this.notifier = note;
    }

    public void setInitialContext(JMeterContext context) {
        this.threadVars.putAll(context.getVariables());
    }

    public boolean isScheduled() {
        return this.scheduler;
    }

    public void setScheduled(boolean sche) {
        this.scheduler = sche;
    }

    public void setStartTime(long stime) {
        this.startTime = stime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void stopScheduler() {
        long delay = System.currentTimeMillis() - this.endTime;
        if (delay >= 0L) {
            this.running = false;
        }
    }

    public void startScheduler() {
        long delay = this.startTime - System.currentTimeMillis();
        if (delay > 0L) {
            try {
                this.running = true;
                Thread.sleep(delay);
            }
            catch (Exception e) {}
        } else {
            this.running = false;
        }
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            this.threadContext = JMeterContextService.getContext();
            this.threadContext.setVariables(this.threadVars);
            this.threadContext.setThreadNum(this.getThreadNum());
            this.testTree.traverse((HashTreeTraverser)this.compiler);
            this.running = true;
            entry = null;
            this.rampUpDelay();
            if (this.scheduler) {
                this.startScheduler();
            }
            JMeterThread.log.info("Thread " + Thread.currentThread().getName() + " started");
            this.controller.initialize();
            this.controller.addIterationListener(new IterationListener());
            this.threadContext.setSamplingStarted(true);
            ** GOTO lbl37
            {
                try {
                    this.threadContext.setCurrentSampler((Sampler)var2_2);
                    pack = this.compiler.configureSampler((Sampler)var2_2);
                    this.delay(pack.getTimers());
                    result = pack.getSampler().sample(null);
                    result.setThreadName(this.threadName);
                    result.setTimeStamp(System.currentTimeMillis());
                    this.threadContext.setPreviousResult(result);
                    this.runPostProcessors(pack.getPostProcessors());
                    this.checkAssertions(pack.getAssertions(), result);
                    this.notifyListeners(pack.getSampleListeners(), result);
                    this.compiler.done(pack);
                    if (this.scheduler) {
                        this.stopScheduler();
                    }
                }
                catch (Exception e) {
                    JMeterThread.log.error("", (Throwable)e);
                }
                do {
                    if (this.running && (sam = this.controller.next()) != null) continue block5;
                    if (!this.controller.isDone()) continue;
                    this.running = false;
lbl37:
                    // 3 sources

                } while (this.running);
            }
        }
        finally {
            this.threadContext.clear();
            JMeterThread.log.info("Thread " + this.threadName + " is done");
            this.monitor.threadFinished(this);
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("stopping " + this.threadName);
    }

    private void checkAssertions(List assertions, SampleResult result) {
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            AssertionResult assertion = ((Assertion)iter.next()).getResult(result);
            result.setSuccessful(result.isSuccessful() && !assertion.isError() && !assertion.isFailure());
            result.addAssertionResult(assertion);
        }
    }

    private void runPostProcessors(List extractors) {
        ListIterator iter = extractors.listIterator(extractors.size());
        while (iter.hasPrevious()) {
            PostProcessor ex = (PostProcessor)iter.previous();
            ex.process();
        }
    }

    private void delay(List timers) {
        block3: {
            int sum = 0;
            Iterator iter = timers.iterator();
            while (iter.hasNext()) {
                sum = (int)((long)sum + ((Timer)iter.next()).delay());
            }
            if (sum <= 0) break block3;
            try {
                Thread.sleep(sum);
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void notifyTestListeners() {
        this.threadVars.incIteration();
        Iterator iter = this.testListeners.iterator();
        while (iter.hasNext()) {
            TestListener listener = (TestListener)iter.next();
            if (listener instanceof TestElement) {
                listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
                ((TestElement)((Object)listener)).recoverRunningVersion();
                continue;
            }
            listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
        }
    }

    private void notifyListeners(List listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, this.controller.getPropertyAsString("TestElement.name"));
        this.compiler.sampleOccurred(event);
        this.notifier.notifyListeners(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        block2: {
            if (this.initialDelay <= 0) break block2;
            try {
                Thread.sleep(this.initialDelay);
            }
            catch (InterruptedException e) {}
        }
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IterationListener
    implements LoopIterationListener {
        private IterationListener() {
        }

        public void iterationStart(LoopIterationEvent iterEvent) {
            JMeterThread.this.notifyTestListeners();
        }
    }
}

