/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.gui.util.JDateField;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;

public class ThreadGroupGui
extends AbstractJMeterGuiComponent
implements ItemListener {
    LoopControlPanel loopPanel;
    private VerticalPanel mainPanel;
    private static final String THREAD_NAME = "Thread Field";
    private static final String RAMP_NAME = "Ramp Up Field";
    private JTextField threadInput;
    private JTextField rampInput;
    private JDateField start;
    private JDateField end;
    private JCheckBox scheduler;

    public ThreadGroupGui() {
        this.init();
    }

    public Collection getMenuCategories() {
        return null;
    }

    public TestElement createTestElement() {
        ThreadGroup tg = new ThreadGroup();
        this.modifyTestElement(tg);
        return tg;
    }

    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        if (tg instanceof ThreadGroup) {
            ((ThreadGroup)tg).setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
        tg.setProperty("ThreadGroup.num_threads", this.threadInput.getText());
        tg.setProperty("ThreadGroup.ramp_time", this.rampInput.getText());
        tg.setProperty(new LongProperty("ThreadGroup.start_time", this.start.getDate().getTime()));
        tg.setProperty(new LongProperty("ThreadGroup.end_time", this.end.getDate().getTime()));
        tg.setProperty(new BooleanProperty("ThreadGroup.scheduler", this.scheduler.isSelected()));
    }

    public void configure(TestElement tg) {
        super.configure(tg);
        this.threadInput.setText(tg.getPropertyAsString("ThreadGroup.num_threads"));
        this.rampInput.setText(tg.getPropertyAsString("ThreadGroup.ramp_time"));
        this.loopPanel.configure((TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue());
        this.scheduler.setSelected(tg.getPropertyAsBoolean("ThreadGroup.scheduler"));
        if (this.scheduler.isSelected()) {
            this.mainPanel.setVisible(true);
        } else {
            this.mainPanel.setVisible(false);
        }
        this.start.setDate(new Date(tg.getPropertyAsLong("ThreadGroup.start_time")));
        this.end.setDate(new Date(tg.getPropertyAsLong("ThreadGroup.end_time")));
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getItem().equals(this.scheduler)) {
            if (this.scheduler.isSelected()) {
                this.mainPanel.setVisible(true);
            } else {
                this.mainPanel.setVisible(false);
            }
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(new String[]{"menu_logic_controller", "menu_listener", "menu_generative_controller", "menu_timer", "menu_config_element", "menu_pre_processors", "menu_post_processors"}, JMeterUtils.getResString("Add"), "Add"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(-1);
        this.loopPanel.configure(looper);
        return this.loopPanel;
    }

    private JPanel createStartTimePanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("starttime"));
        panel.add((Component)label, "West");
        Date today = new Date();
        this.start = new JDateField(today);
        panel.add((Component)this.start, "Center");
        return panel;
    }

    private JPanel createEndTimePanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("endtime"));
        panel.add((Component)label, "West");
        Date today = new Date();
        this.end = new JDateField(today);
        panel.add((Component)this.end, "Center");
        return panel;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("threadgroup");
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        VerticalPanel threadPropsPanel = new VerticalPanel();
        threadPropsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("thread_delay_properties")));
        JPanel threadPanel = new JPanel(new BorderLayout(5, 0));
        JLabel threadLabel = new JLabel(JMeterUtils.getResString("number_of_threads"));
        threadPanel.add((Component)threadLabel, "West");
        this.threadInput = new JTextField("1", 5);
        this.threadInput.setName(THREAD_NAME);
        threadLabel.setLabelFor(this.threadInput);
        threadPanel.add((Component)this.threadInput, "Center");
        threadPropsPanel.add(threadPanel);
        new FocusRequester(this.threadInput);
        JPanel rampPanel = new JPanel(new BorderLayout(5, 0));
        JLabel rampLabel = new JLabel(JMeterUtils.getResString("ramp_up"));
        rampPanel.add((Component)rampLabel, "West");
        this.rampInput = new JTextField("1", 5);
        this.rampInput.setName(RAMP_NAME);
        rampLabel.setLabelFor(this.rampInput);
        rampPanel.add((Component)this.rampInput, "Center");
        threadPropsPanel.add(rampPanel);
        threadPropsPanel.add(this.createControllerPanel());
        this.scheduler = new JCheckBox(JMeterUtils.getResString("scheduler"));
        this.scheduler.addItemListener(this);
        threadPropsPanel.add(this.scheduler);
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("scheduler_configuration")));
        this.mainPanel.add(this.createStartTimePanel());
        this.mainPanel.add(this.createEndTimePanel());
        this.mainPanel.setVisible(false);
        VerticalPanel intgrationPanel = new VerticalPanel();
        intgrationPanel.add(threadPropsPanel);
        intgrationPanel.add(this.mainPanel);
        this.add((Component)intgrationPanel, "Center");
    }

    public void setNode(JMeterTreeNode node) {
        this.getNamePanel().setNode(node);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

