/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.SSLSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jmeter.util.keystore.JmeterKeyStore;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class JsseSSLManager
extends SSLManager {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.util");
    private SecureRandom rand;
    private SSLContext context = null;
    private Provider pro = null;
    static /* synthetic */ Class class$org$apache$jmeter$util$SSLManager;

    public JsseSSLManager(Provider provider) {
        log.debug("ssl Provider =  " + provider);
        this.setProvider(provider);
        try {
            Class<?> iaikProvider = (class$org$apache$jmeter$util$SSLManager == null ? (class$org$apache$jmeter$util$SSLManager = JsseSSLManager.class$("org.apache.jmeter.util.SSLManager")) : class$org$apache$jmeter$util$SSLManager).getClassLoader().loadClass("iaik.security.jsse.provider.IAIKJSSEProvider");
            this.setProvider((Provider)iaikProvider.newInstance());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == this.rand) {
            this.rand = new SecureRandom();
        }
        if ("all".equalsIgnoreCase(JMeterUtils.getPropDefault("javax.net.debug", "none"))) {
            System.setProperty("javax.net.debug", "all");
        }
        this.getContext();
        log.info("JsseSSLManager installed");
    }

    public void setContext(HttpURLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection secureConn = (HttpsURLConnection)conn;
            secureConn.setSSLSocketFactory(this.getContext().getSocketFactory());
        } else if (conn instanceof HttpsURLConnectionImpl) {
            HttpsURLConnectionImpl secureConn = (HttpsURLConnectionImpl)conn;
            secureConn.setSSLSocketFactory(this.getContext().getSocketFactory());
        }
    }

    protected final void setProvider(Provider p) {
        super.setProvider(p);
        if (null == this.pro) {
            this.pro = p;
        }
    }

    private SSLContext getContext() {
        if (null == this.context) {
            int i;
            try {
                this.context = this.pro != null ? SSLContext.getInstance((String)"TLS", (Provider)this.pro) : SSLContext.getInstance((String)"TLS");
                log.debug("SSL context = " + this.context);
            }
            catch (Exception ee) {
                log.error("Exception occurred", (Throwable)ee);
            }
            try {
                KeyManagerFactory managerFactory = KeyManagerFactory.getInstance((String)"SunX509");
                JmeterKeyStore keys = this.getKeyStore();
                managerFactory.init(null, this.defaultpw.toCharArray());
                KeyManager[] managers = managerFactory.getKeyManagers();
                log.info(keys.getClass().toString());
                i = 0;
                while (i < managers.length) {
                    if (managers[i] instanceof X509KeyManager) {
                        X509KeyManager manager = (X509KeyManager)managers[i];
                        managers[i] = new WrappedX509KeyManager(manager, keys);
                    }
                    ++i;
                }
                TrustManager[] trusts = new TrustManager[]{new AlwaysTrustManager(this.getTrustStore())};
                this.context.init(managers, trusts, this.rand);
                HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)this.context.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new HostnameVerifier(){

                    public boolean verify(String urlHostname, String certHostname) {
                        return true;
                    }
                });
                log.debug("SSL stuff all set");
            }
            catch (Exception e) {
                log.error("Exception occurred", (Throwable)e);
            }
            String[] dCiphers = this.context.getSocketFactory().getDefaultCipherSuites();
            String[] sCiphers = this.context.getSocketFactory().getSupportedCipherSuites();
            int len = dCiphers.length > sCiphers.length ? dCiphers.length : sCiphers.length;
            i = 0;
            while (i < len) {
                if (i < dCiphers.length) {
                    log.info("Default Cipher: " + dCiphers[i]);
                }
                if (i < sCiphers.length) {
                    log.info("Supported Cipher: " + sCiphers[i]);
                }
                ++i;
            }
        }
        return this.context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WrappedX509KeyManager
    implements X509KeyManager {
        private final X509KeyManager manager;
        private final JmeterKeyStore store;

        public WrappedX509KeyManager(X509KeyManager parent, JmeterKeyStore ks) {
            this.manager = parent;
            this.store = ks;
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            log.info("WrappedX509Manager: getClientAliases: ");
            log.info(this.store.getAlias());
            return new String[]{this.store.getAlias()};
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            log.info("WrappedX509Manager: getServerAliases: ");
            log.info(this.manager.getServerAliases(keyType, issuers).toString());
            return this.manager.getServerAliases(keyType, issuers);
        }

        public X509Certificate[] getCertificateChain(String alias) {
            log.info("WrappedX509Manager: getCertificateChain(" + alias + ")");
            log.info(this.store.getCertificateChain().toString());
            return this.store.getCertificateChain();
        }

        public PrivateKey getPrivateKey(String alias) {
            log.info("WrappedX509Manager: getPrivateKey: " + this.store.getPrivateKey());
            return this.store.getPrivateKey();
        }

        public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
            log.info("Alias: " + this.store.getAlias());
            return this.store.getAlias();
        }

        public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
            return this.manager.chooseServerAlias(arg0, arg1);
        }

        public String chooseClientAlias(String arg0, Principal[] arg1) {
            return this.store.getAlias();
        }

        public String chooseServerAlias(String arg0, Principal[] arg1) {
            return this.manager.chooseServerAlias(arg0, arg1);
        }
    }

    protected static class AlwaysTrustManager
    implements X509TrustManager {
        protected X509Certificate[] certs;

        public AlwaysTrustManager(KeyStore store) {
            try {
                Enumeration<String> enumeration = store.aliases();
                ArrayList<Certificate> list = new ArrayList<Certificate>(store.size());
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    log.info("AlwaysTrustManager alias: " + alias);
                    if (store.isCertificateEntry(alias)) {
                        list.add(store.getCertificate(alias));
                        log.info(" INSTALLED");
                        continue;
                    }
                    log.info(" SKIPPED");
                }
                this.certs = list.toArray(new X509Certificate[0]);
            }
            catch (Exception e) {
                this.certs = null;
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            log.info("Get accepted Issuers");
            return this.certs;
        }

        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public boolean isClientTrusted(X509Certificate[] arg0) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] arg0) {
            return true;
        }
    }
}

