/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.keystore.JmeterKeyStore;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class SSLManager {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.util");
    private static SSLManager manager;
    private static boolean isIAIKProvider;
    private static boolean isSSLSupported;
    private static Provider sslProvider;
    private JmeterKeyStore keyStore;
    private KeyStore trustStore;
    protected String defaultpw = JMeterUtils.getJMeterProperties().getProperty("javax.net.ssl.keyStorePassword");
    static /* synthetic */ Class class$java$security$Provider;

    public static void reset() {
        manager = null;
    }

    public abstract void setContext(HttpURLConnection var1);

    protected void setProvider(Provider provider) {
        if (null != provider) {
            Security.addProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JmeterKeyStore getKeyStore() {
        String password = this.defaultpw;
        if (null == this.keyStore) {
            String defaultName = JMeterUtils.getJMeterProperties().getProperty("user.home") + File.separator + ".keystore";
            String fileName = JMeterUtils.getJMeterProperties().getProperty("javax.net.ssl.keyStore", defaultName);
            System.setProperty("javax.net.ssl.keyStore", fileName);
            try {
                if (fileName.endsWith(".p12") || fileName.endsWith(".P12")) {
                    this.keyStore = JmeterKeyStore.getInstance("pkcs12");
                    log.info("KeyStore Type: PKCS 12");
                    System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
                } else {
                    this.keyStore = JmeterKeyStore.getInstance("JKS");
                    log.info("KeyStore Type: JKS");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), e, JMeterUtils.getResString("ssl_error_title"), 0);
                this.keyStore = null;
                throw new RuntimeException("KeyStore Problem");
            }
            if (null == password) {
                if (null == this.defaultpw) {
                    this.defaultpw = JMeterUtils.getJMeterProperties().getProperty("javax.net.ssl.keyStorePassword", "password");
                    if (null == this.defaultpw) {
                        SSLManager e = this;
                        synchronized (e) {
                            this.defaultpw = JOptionPane.showInputDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("ssl_pass_prompt"), JMeterUtils.getResString("ssl_pass_title"), 3);
                            JMeterUtils.getJMeterProperties().setProperty("javax.net.ssl.keyStorePassword", this.defaultpw);
                        }
                    }
                }
                password = this.defaultpw;
                System.setProperty("javax.net.ssl.keyStorePassword", password);
            }
            try {
                File initStore = new File(fileName);
                if (initStore.exists()) {
                    this.keyStore.load(new FileInputStream(initStore), password);
                } else {
                    this.keyStore.load(null, password);
                }
            }
            catch (Exception e) {
                log.error("Couldn't load keystore", (Throwable)e);
            }
            log.info("JmeterKeyStore Location: " + fileName);
            log.info("JmeterKeyStore type: " + this.keyStore.getClass().toString());
        }
        return this.keyStore;
    }

    protected KeyStore getTrustStore() {
        if (null == this.trustStore) {
            String fileName = JMeterUtils.getPropDefault("javax.net.ssl.trustStore", "");
            System.setProperty("javax.net.ssl.trustStore", fileName);
            try {
                if (fileName.endsWith(".iaik")) {
                    this.trustStore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
                } else {
                    this.trustStore = KeyStore.getInstance("JKS");
                    log.info("KeyStore Type: JKS");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), e, JMeterUtils.getResString("ssl_error_title"), 0);
                this.trustStore = null;
                throw new RuntimeException("TrustStore Problem");
            }
            try {
                File initStore = new File(fileName);
                if (initStore.exists()) {
                    this.trustStore.load(new FileInputStream(initStore), null);
                } else {
                    this.trustStore.load(null, null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't load TrustStore: " + e.toString());
            }
            log.info("TrustStore Location: " + fileName);
            log.info("TrustStore type: " + this.keyStore.getClass().toString());
        }
        return this.trustStore;
    }

    protected SSLManager() {
    }

    public static final SSLManager getInstance() {
        if (null == manager && isSSLSupported) {
            String classname = null;
            classname = isIAIKProvider ? "org.apache.jmeter.util.IaikSSLManager" : "org.apache.jmeter.util.JsseSSLManager";
            try {
                Class<?> clazz = Class.forName(classname);
                Constructor<?> con = clazz.getConstructor(class$java$security$Provider == null ? (class$java$security$Provider = SSLManager.class$("java.security.Provider")) : class$java$security$Provider);
                manager = (SSLManager)con.newInstance(sslProvider);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                isSSLSupported = false;
                return null;
            }
        }
        return manager;
    }

    public static final boolean isSSLSupported() {
        return isSSLSupported;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isIAIKProvider = false;
        isSSLSupported = false;
        sslProvider = null;
        isSSLSupported = true;
        sslProvider = null;
    }
}

