/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractVisualizer
extends AbstractJMeterGuiComponent
implements Visualizer,
ChangeListener,
UnsharedComponent {
    protected static transient Logger log = LoggingManager.getLoggerForClass();
    private FilePanel filePanel;
    private JCheckBox errorLogging = new JCheckBox(JMeterUtils.getResString("log_errors_only"));
    ResultCollector collector;

    public AbstractVisualizer() {
        this.filePanel = new FilePanel(JMeterUtils.getResString("file_visualizer_output_file"), ".jtl");
        this.filePanel.addChangeListener(this);
        this.filePanel.add(this.errorLogging);
    }

    protected JCheckBox getErrorLoggingCheckbox() {
        return this.errorLogging;
    }

    protected ResultCollector getModel() {
        return this.collector;
    }

    protected Component getFilePanel() {
        return this.filePanel;
    }

    public void setFile(String filename) {
        this.filePanel.setFilename(filename);
    }

    public String getFile() {
        return this.filePanel.getFilename();
    }

    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultVisualizerMenu();
    }

    public void stateChanged(ChangeEvent e) {
        log.info("getting new collector");
        this.collector = (ResultCollector)this.createTestElement();
        try {
            this.collector.loadExistingFile();
        }
        catch (Exception err) {
            log.debug("Error occurred while loading file", (Throwable)err);
        }
    }

    public Collection getMenuCategories() {
        return Arrays.asList("menu_listener");
    }

    public TestElement createTestElement() {
        if (this.collector == null) {
            this.collector = new ResultCollector();
        }
        this.modifyTestElement(this.collector);
        return (TestElement)this.collector.clone();
    }

    public void modifyTestElement(TestElement c) {
        this.configureTestElement((AbstractListenerElement)c);
        if (c instanceof ResultCollector) {
            ResultCollector rc = (ResultCollector)c;
            rc.setErrorLogging(this.errorLogging.isSelected());
            rc.setFilename(this.getFile());
            this.collector = rc;
        }
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.setFile(el.getPropertyAsString("filename"));
        ResultCollector rc = (ResultCollector)el;
        this.errorLogging.setSelected(rc.isErrorLogging());
    }

    protected void configureTestElement(AbstractListenerElement mc) {
        super.configureTestElement(mc);
        mc.setListener(this);
    }

    protected Container makeTitlePanel() {
        Container panel = super.makeTitlePanel();
        panel.add(this.getFilePanel());
        return panel;
    }

    protected void setModel(ResultCollector collector) {
        this.collector = collector;
    }
}

