/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ObjectName;
import javax.management.loading.PrivateClassLoader;

public final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private static final LoaderEntry[] EMPTY_LOADER_ARRAY = new LoaderEntry[0];
    private LoaderEntry[] loaders = EMPTY_LOADER_ARRAY;
    private final Hashtable search = new Hashtable(10);
    private final Hashtable loadersWithNames = new Hashtable(10);
    private static final String dbgTag = "ClassLoaderRepositorySupport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean add(ObjectName objectName, ClassLoader classLoader) {
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            ArrayList<LoaderEntry> arrayList = new ArrayList<LoaderEntry>(Arrays.asList(this.loaders));
            arrayList.add(new LoaderEntry(objectName, classLoader));
            this.loaders = arrayList.toArray(EMPTY_LOADER_ARRAY);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean remove(ObjectName objectName, ClassLoader classLoader) {
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            int n = this.loaders.length;
            int n2 = 0;
            while (n2 < n) {
                boolean bl;
                LoaderEntry loaderEntry = this.loaders[n2];
                boolean bl2 = objectName == null ? classLoader == loaderEntry.loader : (bl = objectName.equals(loaderEntry.name));
                if (bl) {
                    LoaderEntry[] loaderEntryArray = new LoaderEntry[n - 1];
                    System.arraycopy(this.loaders, 0, loaderEntryArray, 0, n2);
                    System.arraycopy(this.loaders, n2 + 1, loaderEntryArray, n2, n - 1 - n2);
                    this.loaders = loaderEntryArray;
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public final Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(this.loaders, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassWithout", string + "\twithout " + classLoader);
        }
        if (classLoader == null) {
            return this.loadClass(this.loaders, string, null, null);
        }
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(this.loaders, string, classLoader, null);
            Object var5_4 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassBefore(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassBefore", string + "\tbefore " + classLoader);
        }
        if (classLoader == null) {
            return this.loadClass(this.loaders, string, null, null);
        }
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(this.loaders, string, null, classLoader);
            Object var5_4 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    private final Class loadClass(LoaderEntry[] loaderEntryArray, String string, ClassLoader classLoader, ClassLoader classLoader2) throws ClassNotFoundException {
        int n = loaderEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                ClassLoader classLoader3 = loaderEntryArray[n2].loader;
                if (classLoader3 == null) {
                    return Class.forName(string, false, null);
                }
                if (classLoader3 != classLoader) {
                    if (classLoader3 == classLoader2) break;
                    if (ClassLoaderRepositorySupport.isTraceOn()) {
                        ClassLoaderRepositorySupport.trace("loadClass", "trying loader = " + classLoader3);
                    }
                    return classLoader3.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        throw new ClassNotFoundException(string);
    }

    private final synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Vector<ClassLoader> vector = (Vector<ClassLoader>)this.search.get(string);
        if (vector != null && vector.contains(classLoader)) {
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("startValidSearch", "already requested loader=" + classLoader + " class= " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (vector == null) {
            vector = new Vector<ClassLoader>(1);
            this.search.put(string, vector);
        }
        vector.addElement(classLoader);
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("startValidSearch", "loader=" + classLoader + " class= " + string);
        }
    }

    private final synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        Vector vector = (Vector)this.search.get(string);
        if (vector != null) {
            vector.removeElement(classLoader);
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("stopValidSearch", "loader=" + classLoader + " class= " + string);
            }
        }
    }

    public final void addClassLoader(ClassLoader classLoader) {
        this.add(null, classLoader);
    }

    public final void removeClassLoader(ClassLoader classLoader) {
        this.remove(null, classLoader);
    }

    public final synchronized void addClassLoader(ObjectName objectName, ClassLoader classLoader) {
        this.loadersWithNames.put(objectName, classLoader);
        if (!(classLoader instanceof PrivateClassLoader)) {
            this.add(objectName, classLoader);
        }
    }

    public final synchronized void removeClassLoader(ObjectName objectName) {
        ClassLoader classLoader = (ClassLoader)this.loadersWithNames.remove(objectName);
        if (!(classLoader instanceof PrivateClassLoader)) {
            this.remove(objectName, classLoader);
        }
    }

    public final ClassLoader getClassLoader(ObjectName objectName) {
        return (ClassLoader)this.loadersWithNames.get(objectName);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        ClassLoaderRepositorySupport.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        ClassLoaderRepositorySupport.debug(dbgTag, string, string2);
    }

    private static class LoaderEntry {
        ObjectName name;
        ClassLoader loader;

        LoaderEntry(ObjectName objectName, ClassLoader classLoader) {
            this.name = objectName;
            this.loader = classLoader;
        }
    }
}

