/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class RepositorySupport
implements Repository {
    private static final ObjectName _WholeWordQueryObjectName;
    private static int _slen;
    private static int _plen;
    private final Hashtable domainTb = new Hashtable(5);
    private int nbElements = 0;
    private final String domain;
    private static final String dbgTag = "Repository";

    private static final boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static final void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static final void trace(String string, String string2) {
        RepositorySupport.trace(dbgTag, string, string2);
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static final void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static final void debug(String string, String string2) {
        RepositorySupport.debug(dbgTag, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addAllMatching(Hashtable hashtable, Set set, ObjectNamePattern objectNamePattern) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                NamedObject namedObject = (NamedObject)enumeration.nextElement();
                ObjectName objectName = namedObject.getName();
                if (!objectNamePattern.matchKeys(objectName)) continue;
                set.add(namedObject);
            }
        }
    }

    private final void addNewDomMoi(Object object, String string, ObjectName objectName) {
        Hashtable<String, NamedObject> hashtable = new Hashtable<String, NamedObject>();
        this.domainTb.put(string, hashtable);
        hashtable.put(objectName.getCanonicalKeyPropertyListString(), new NamedObject(objectName, object));
        ++this.nbElements;
    }

    private static boolean wildmatch(char[] cArray, char[] cArray2, int n, int n2) {
        _slen = cArray.length;
        _plen = cArray2.length;
        while (n2 < _plen) {
            char c;
            if ((c = cArray2[n2++]) == '?') {
                if (++n <= _slen) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= _plen) {
                    return true;
                }
                do {
                    if (!RepositorySupport.wildmatch(cArray, cArray2, n, n2)) continue;
                    return true;
                } while (++n < _slen);
                return false;
            }
            if (n < _slen && c == cArray[n++]) continue;
            return false;
        }
        return n == _slen;
    }

    private NamedObject retrieveNamedObject(ObjectName objectName) {
        Object v;
        if (objectName.isPattern()) {
            return null;
        }
        String string = objectName.getDomain().intern();
        if (string.length() == 0) {
            string = this.domain;
        }
        if ((v = this.domainTb.get(string)) == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)v;
        Object v2 = hashtable.get(objectName.getCanonicalKeyPropertyListString());
        if (v2 != null) {
            return (NamedObject)v2;
        }
        return null;
    }

    public RepositorySupport(String string) {
        this.domain = string != null && string.length() != 0 ? string : "DefaultDomain";
        this.domainTb.put(this.domain.intern(), new Hashtable());
    }

    public void setConfigParameters(ArrayList arrayList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        ArrayList<String> arrayList;
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            arrayList = new ArrayList<String>(this.domainTb.size());
            Enumeration enumeration = this.domainTb.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2;
                String string = (String)enumeration.nextElement();
                if (string == null || (hashtable2 = (Hashtable)this.domainTb.get(string)) == null || hashtable2.size() == 0) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isFiltering() {
        return false;
    }

    public void addMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        boolean bl;
        String string;
        block10: {
            if (RepositorySupport.isTraceOn()) {
                RepositorySupport.trace("addMBean", "name=" + objectName);
            }
            string = objectName.getDomain().intern();
            bl = false;
            if (string.length() == 0) {
                try {
                    objectName = new ObjectName(this.domain + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!RepositorySupport.isDebugOn()) break block10;
                    RepositorySupport.debug("addMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        if (string == this.domain) {
            bl = true;
            string = this.domain;
        } else {
            bl = false;
        }
        if (objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: cannot add mbean for pattern name " + objectName.toString()));
        }
        if (!bl && string.equals("JMImplementation") && this.domainTb.containsKey("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
        }
        Hashtable hashtable = (Hashtable)this.domainTb.get(string);
        if (hashtable == null) {
            this.addNewDomMoi(object, string, objectName);
            return;
        }
        String string2 = objectName.getCanonicalKeyPropertyListString();
        Object v = hashtable.get(string2);
        if (v != null) {
            throw new InstanceAlreadyExistsException(objectName.toString());
        }
        ++this.nbElements;
        hashtable.put(string2, new NamedObject(objectName, object));
    }

    public boolean contains(ObjectName objectName) {
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("contains", "name=" + objectName);
        }
        return this.retrieveNamedObject(objectName) != null;
    }

    public Object retrieve(ObjectName objectName) {
        NamedObject namedObject;
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("retrieve", "name=" + objectName);
        }
        if ((namedObject = this.retrieveNamedObject(objectName)) == null) {
            return null;
        }
        return namedObject.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set query(ObjectName objectName, QueryExp queryExp) {
        ObjectNamePattern objectNamePattern = null;
        HashSet<NamedObject> hashSet = new HashSet<NamedObject>();
        ObjectName objectName2 = null;
        objectName2 = objectName == null || objectName.getCanonicalName().length() == 0 || objectName.equals(_WholeWordQueryObjectName) ? _WholeWordQueryObjectName : objectName;
        if (!objectName2.isPattern()) {
            try {
                NamedObject namedObject = this.retrieveNamedObject(objectName2);
                if (namedObject != null) {
                    hashSet.add(namedObject);
                }
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                // empty catch block
            }
            return hashSet;
        }
        if (objectName2 == _WholeWordQueryObjectName) {
            Hashtable hashtable = this.domainTb;
            synchronized (hashtable) {
                Enumeration enumeration = this.domainTb.elements();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                    hashSet.addAll(hashtable2.values());
                }
            }
            return hashSet;
        }
        String string = objectName2.getCanonicalKeyPropertyListString();
        if (objectName2.getDomain().length() == 0) {
            Hashtable hashtable = (Hashtable)this.domainTb.get(this.domain);
            if (string.length() == 0) {
                hashSet.addAll(hashtable.values());
            } else {
                if (objectNamePattern == null) {
                    objectNamePattern = new ObjectNamePattern(objectName2);
                }
                this.addAllMatching(hashtable, hashSet, objectNamePattern);
            }
            return hashSet;
        }
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            char[] cArray = objectName2.getDomain().toCharArray();
            Enumeration enumeration = this.domainTb.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                char[] cArray2 = string2.toCharArray();
                if (!RepositorySupport.wildmatch(cArray2, cArray, 0, 0)) continue;
                Hashtable hashtable3 = (Hashtable)this.domainTb.get(string2);
                if (string.length() == 0) {
                    hashSet.addAll(hashtable3.values());
                    continue;
                }
                if (objectNamePattern == null) {
                    objectNamePattern = new ObjectNamePattern(objectName2);
                }
                this.addAllMatching(hashtable3, hashSet, objectNamePattern);
            }
        }
        return hashSet;
    }

    public void remove(ObjectName objectName) throws InstanceNotFoundException {
        Object v;
        String string;
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("remove", "name=" + objectName);
        }
        if ((string = objectName.getDomain().intern()).length() == 0) {
            string = this.domain;
        }
        if ((v = this.domainTb.get(string)) == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Hashtable hashtable = (Hashtable)v;
        if (hashtable.remove(objectName.getCanonicalKeyPropertyListString()) == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        --this.nbElements;
        if (hashtable.isEmpty()) {
            this.domainTb.remove(string);
            if (string == this.domain) {
                this.domainTb.put(this.domain, new Hashtable());
            }
        }
    }

    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    static {
        try {
            _WholeWordQueryObjectName = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new UnsupportedOperationException(malformedObjectNameException.getMessage());
        }
    }

    private static final class ObjectNamePattern {
        private final char[] domain;
        private final String[] keys;
        private final String[] values;
        private final String properties;
        private final boolean isPropertyPattern;
        public final ObjectName pattern;

        public ObjectNamePattern(ObjectName objectName) {
            this(objectName.isPattern(), objectName.getDomain(), objectName.isPropertyPattern(), objectName.getCanonicalKeyPropertyListString(), objectName.getKeyPropertyList(), objectName);
        }

        ObjectNamePattern(boolean bl, String string, boolean bl2, String string2, Hashtable hashtable, ObjectName objectName) {
            int n = hashtable == null ? 0 : hashtable.size();
            Enumeration enumeration = hashtable == null ? null : hashtable.keys();
            this.domain = string == null ? null : string.toCharArray();
            this.keys = new String[n];
            this.values = new String[n];
            int n2 = 0;
            while (n2 < n) {
                String string3;
                this.keys[n2] = string3 = (String)enumeration.nextElement();
                this.values[n2] = (String)hashtable.get(string3);
                ++n2;
            }
            this.properties = string2;
            this.isPropertyPattern = bl2;
            this.pattern = objectName;
        }

        public boolean matchKeys(ObjectName objectName) {
            if (this.isPropertyPattern) {
                int n = this.keys.length - 1;
                while (n >= 0) {
                    String string = objectName.getKeyProperty(this.keys[n]);
                    if (string == null) {
                        return false;
                    }
                    if (!string.equals(this.values[n])) {
                        return false;
                    }
                    --n;
                }
                return true;
            }
            if (this.keys.length != objectName.getKeyPropertyList().size()) {
                return false;
            }
            String string = objectName.getCanonicalKeyPropertyListString();
            String string2 = this.properties;
            return string.equals(string2);
        }
    }
}

