/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.management.MBeanServerPermissionCollection;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;
    private static final int CREATE = 0;
    private static final int FIND = 1;
    private static final int NEW = 2;
    private static final int RELEASE = 3;
    private static final int N_NAMES = 4;
    private static final String[] names = new String[]{"createMBeanServer", "findMBeanServer", "newMBeanServer", "releaseMBeanServer"};
    private static final int CREATE_MASK = 1;
    private static final int FIND_MASK = 2;
    private static final int NEW_MASK = 4;
    private static final int RELEASE_MASK = 8;
    private static final int ALL_MASK = 15;
    private static final String[] canonicalNames = new String[16];
    transient int mask;

    public MBeanServerPermission(String string) {
        this(string, null);
    }

    public MBeanServerPermission(String string, String string2) {
        super(MBeanServerPermission.getCanonicalName(MBeanServerPermission.parseMask(string)), string2);
        this.mask = MBeanServerPermission.parseMask(string);
        if (string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException("MBeanServerPermission actions must be null: " + string2);
        }
    }

    MBeanServerPermission(int n) {
        super(MBeanServerPermission.getCanonicalName(n));
        this.mask = MBeanServerPermission.impliedMask(n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mask = MBeanServerPermission.parseMask(this.getName());
    }

    static int simplifyMask(int n) {
        if ((n & 1) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    static int impliedMask(int n) {
        if ((n & 1) != 0) {
            n |= 4;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCanonicalName(int n) {
        if (n == 15) {
            return "*";
        }
        n = MBeanServerPermission.simplifyMask(n);
        String[] stringArray = canonicalNames;
        synchronized (stringArray) {
            if (canonicalNames[n] == null) {
                MBeanServerPermission.canonicalNames[n] = MBeanServerPermission.makeCanonicalName(n);
            }
        }
        return canonicalNames[n];
    }

    private static String makeCanonicalName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < 4) {
            if ((n & 1 << n2) != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(names[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString().intern();
    }

    private static int parseMask(String string) {
        if (string == null) {
            throw new NullPointerException("MBeanServerPermission: target name can't be null");
        }
        if ((string = string.trim()).equals("*")) {
            return 15;
        }
        if (string.indexOf(44) < 0) {
            return MBeanServerPermission.impliedMask(1 << MBeanServerPermission.nameIndex(string.trim()));
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = MBeanServerPermission.nameIndex(string2.trim());
            n |= 1 << n2;
        }
        return MBeanServerPermission.impliedMask(n);
    }

    private static int nameIndex(String string) throws IllegalArgumentException {
        int n = 0;
        while (n < 4) {
            if (names[n].equals(string)) {
                return n;
            }
            ++n;
        }
        String string2 = "Invalid MBeanServerPermission name: \"" + string + "\"";
        throw new IllegalArgumentException(string2);
    }

    public int hashCode() {
        return this.mask;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)permission;
        return (this.mask & mBeanServerPermission.mask) == mBeanServerPermission.mask;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)object;
        return this.mask == mBeanServerPermission.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }
}

