/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanGauge = new Number[16];
    private transient int[] status = new int[16];
    private transient int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            int n = 0;
            while (n < this.elementCount) {
                this.status[n] = 2;
                this.previousScanGauge[n] = null;
                ++n;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        } else if (this.isTraceOn()) {
            this.trace("start", "the gauge monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the gauge monitor");
        }
        if (this.isActive()) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the counter monitor is already deactivated");
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public Number getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    public synchronized void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number, number.getClass().getName())) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        this.highThreshold = number;
        this.lowThreshold = number2;
        int n = 0;
        while (n < this.elementCount) {
            this.resetAlreadyNotified(n, 16);
            this.status[n] = 2;
            ++n;
        }
    }

    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public synchronized void setNotifyHigh(boolean bl) {
        this.notifyHigh = bl;
    }

    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    public synchronized void setNotifyLow(boolean bl) {
        this.notifyLow = bl;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        int n = 0;
        while (n < this.elementCount) {
            this.status[n] = 2;
            this.previousScanGauge[n] = null;
            ++n;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    private boolean updateDerivedGauge(Object object, int n) {
        boolean bl;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanGauge[n] != null) {
                this.setDerivedGaugeWithDifference((Number)object, n);
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanGauge[n] = (Number)object;
        } else {
            this.derivedGauge[n] = (Number)object;
            bl = true;
        }
        return bl;
    }

    private void updateNotifications(int n) {
        if (this.status[n] == 2) {
            if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.highThreshold, n);
                }
                this.status[n] = 1;
            }
            if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
                if (this.notifyLow) {
                    this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.lowThreshold, n);
                }
                this.status[n] = 0;
            }
        } else if (this.status[n] == 0) {
            if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.highThreshold, n);
                }
                this.status[n] = 1;
            }
        } else if (this.status[n] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
            if (this.notifyLow) {
                this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.lowThreshold, n);
            }
            this.status[n] = 0;
        }
    }

    private boolean isThresholdTypeValid(int n) {
        boolean bl = false;
        switch (this.type[n]) {
            case 0: {
                if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                bl = true;
                break;
            }
            case 1: {
                if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                bl = true;
                break;
            }
            case 2: {
                if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                bl = true;
                break;
            }
            case 4: {
                if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                bl = true;
                break;
            }
            case 5: {
                if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isThresholdTypeValid", "the threshold type is invalid");
            }
        }
        return bl;
    }

    private void setDerivedGaugeWithDifference(Number number, int n) {
        switch (this.type[n]) {
            case 0: {
                this.derivedGauge[n] = new Integer((Integer)number - (Integer)this.previousScanGauge[n]);
                break;
            }
            case 1: {
                this.derivedGauge[n] = new Byte((byte)((Byte)number - (Byte)this.previousScanGauge[n]));
                break;
            }
            case 2: {
                this.derivedGauge[n] = new Short((short)((Short)number - (Short)this.previousScanGauge[n]));
                break;
            }
            case 3: {
                this.derivedGauge[n] = new Long((Long)number - (Long)this.previousScanGauge[n]);
                break;
            }
            case 4: {
                this.derivedGauge[n] = new Float(((Float)number).floatValue() - ((Float)this.previousScanGauge[n]).floatValue());
                break;
            }
            case 5: {
                this.derivedGauge[n] = new Double((Double)number - (Double)this.previousScanGauge[n]);
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    private boolean isFirstGreaterThanLast(Number number, Number number2, int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (number.longValue() < number2.longValue()) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(number.doubleValue() >= number2.doubleValue())) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return bl;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number number, Number number2, String string) {
        boolean bl = false;
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Long")) {
            if (number.longValue() > number2.longValue()) {
                bl = true;
            }
        } else if (string.equals("java.lang.Float") || string.equals("java.lang.Double")) {
            if (number.doubleValue() > number2.doubleValue()) {
                bl = true;
            }
        } else if (this.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return bl;
    }

    void notifyAlarmClock(int n) {
        block31: {
            Object object = null;
            String string = null;
            try {
                if (!this.isActive()) break block31;
                if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                    if (object == null) {
                        return;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 1) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.setAlreadyNotified(n, 1);
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (object instanceof Integer) {
                    this.type[n] = 0;
                } else if (object instanceof Byte) {
                    this.type[n] = 1;
                } else if (object instanceof Short) {
                    this.type[n] = 2;
                } else if (object instanceof Long) {
                    this.type[n] = 3;
                } else if (object instanceof Float) {
                    this.type[n] = 4;
                } else if (object instanceof Double) {
                    this.type[n] = 5;
                } else {
                    if ((this.alreadyNotifieds[n] & 4) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.setAlreadyNotified(n, 4);
                    throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                }
                if (!this.isThresholdTypeValid(n)) {
                    if ((this.alreadyNotifieds[n] & 0x10) != 0) {
                        return;
                    }
                    string = MonitorNotification.THRESHOLD_ERROR;
                    this.setAlreadyNotified(n, 16);
                    throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                }
                this.resetAllAlreadyNotified(n);
                boolean bl = this.updateDerivedGauge(object, n);
                if (bl) {
                    this.updateNotifications(n);
                }
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp[n], monitorSettingException.getMessage(), this.derivedGauge[n], null, n);
                this.status[n] = 2;
                this.previousScanGauge[n] = null;
            }
        }
    }

    void insertSpecificElementAt(int n) {
        Integer n2 = new Integer(0);
        this.insertNumberElementAt(this.derivedGauge, n2, n);
        this.insertNumberElementAt(this.previousScanGauge, null, n);
        this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n);
        this.insertintElementAt(this.status, 2, n);
        this.insertintElementAt(this.type, 0, n);
    }

    void removeSpecificElementAt(int n) {
        this.removeNumberElementAt(this.derivedGauge, n);
        this.removeNumberElementAt(this.previousScanGauge, n);
        this.removelongElementAt(this.derivedGaugeTimestamp, n);
        this.removeintElementAt(this.status, n);
        this.removeintElementAt(this.type, n);
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor gaugeMonitor) {
            this.listener = gaugeMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                int n = 0;
                while (n < this.listener.elementCount) {
                    this.listener.notifyAlarmClock(n);
                    ++n;
                }
            }
        }
    }
}

