/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Table;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.rowio.RowOutputInterface;

public class Row
implements CachedObject {
    int iPos;
    protected Object[] oData;
    protected Node nPrimaryNode;

    Row() {
    }

    Row(Table table, Object[] objectArray) throws HsqlException {
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = Node.newNode(this, n2, table);
            ++n2;
        }
        this.oData = objectArray;
    }

    Node getNode(int n) {
        Node node = this.nPrimaryNode;
        while (n-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNextNode(Node node) {
        node = node == null ? this.nPrimaryNode : node.nNext;
        return node;
    }

    Row getUpdatedRow() throws HsqlException {
        return this;
    }

    public Object[] getData() {
        return this.oData;
    }

    void delete() throws HsqlException {
        ++Record.memoryRecords;
        this.nPrimaryNode = null;
    }

    boolean isDeleted() {
        return this.nPrimaryNode == null;
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 0;
    }

    public void setStorageSize(int n) {
    }

    public int getStorageSize() {
        return 0;
    }

    public int getPos() {
        return this.iPos;
    }

    public void setPos(int n) {
        this.iPos = n;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean isKeepInMemory() {
        return true;
    }

    public void keepInMemory(boolean bl) {
    }

    public boolean isInMemory() {
        return true;
    }

    public void setInMemory(boolean bl) {
    }

    public void write(RowOutputInterface rowOutputInterface) {
    }

    public void write(RowOutputInterface rowOutputInterface, DoubleIntIndex doubleIntIndex) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Row) {
            return ((Row)object).iPos == this.iPos;
        }
        return false;
    }

    public int hashCode() {
        return this.iPos;
    }
}

