/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingIndex = -1;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType = 3;
    boolean isIntoTableQuoted;
    boolean isMainSelect;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private int limitStart;
    private int limitCount;
    Result.ResultMetaData resultMetaData;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.iResultLen) {
            String string = this.exprColumns[n].getAlias();
            if (string != null) {
                hashMap.put(string, this.exprColumns[n]);
            }
            ++n;
        }
        return hashMap;
    }

    void resolve() throws HsqlException {
        this.resolveTables();
        this.resolveTypes();
        this.setFilterConditions();
    }

    void resolveTables() throws HsqlException {
        int n = this.tFilter.length;
        int n2 = 0;
        while (n2 < n) {
            this.resolveTables(this.tFilter[n2]);
            ++n2;
        }
    }

    void resolveTypes() throws HsqlException {
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            this.exprColumns[n2].resolveTypes();
            ++n2;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes();
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            this.exprColumns[n2].resolveTables(tableFilter);
            ++n2;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(tableFilter);
        }
    }

    private void setFilterConditions() throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        int n = 0;
        while (n < this.tFilter.length) {
            this.tFilter[n].setConditions(this.queryCondition);
            ++n;
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        boolean bl2 = true;
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            bl2 = bl2 && this.exprColumns[n2].checkResolved(bl);
            ++n2;
        }
        if (this.queryCondition != null) {
            boolean bl3 = bl2 = bl2 && this.queryCondition.checkResolved(bl);
        }
        if (this.havingCondition != null) {
            bl2 = bl2 && this.havingCondition.checkResolved(bl);
        }
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            if (this.tFilter[n3].filterIndex == null) {
                this.tFilter[n3].filterIndex = this.tFilter[n3].filterTable.getPrimaryIndex();
            }
            ++n3;
        }
        return bl2;
    }

    Object getValue(Session session, int n) throws HsqlException {
        this.resolve();
        Result result = this.getResult(session, 2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        if (n2 == 1 && n3 == 1) {
            Object object = result.rRoot.data[0];
            return result.metaData.colTypes[0] == n ? object : Column.convertObject(object, n);
        }
        HsqlException hsqlException = Trace.error(17);
        if (n2 == 0 && n3 == 1) {
            throw new HsqlInternalException(hsqlException);
        }
        throw hsqlException;
    }

    void prepareResult() throws HsqlException {
        int n;
        this.resolveAll(true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            n = this.iResultLen;
            while (n < this.iResultLen + this.iGroupLen) {
                this.exprColumns[n].collectColumnName(this.groupColumnNames);
                ++n;
            }
        }
        n = this.exprColumns.length;
        Result.ResultMetaData resultMetaData = this.resultMetaData = new Result.ResultMetaData(n);
        int n2 = this.iResultLen;
        int n3 = n2 + this.iGroupLen;
        int n4 = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : n3;
        int n5 = n4 + this.iOrderLen;
        int n6 = 0;
        while (n6 < n) {
            Expression expression = this.exprColumns[n6];
            resultMetaData.colTypes[n6] = expression.getDataType();
            resultMetaData.colSizes[n6] = expression.getColumnSize();
            resultMetaData.colScales[n6] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            if (n6 >= n2 && n6 < n3 && !this.exprColumns[n6].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[n6]);
            }
            if (n6 == this.iHavingIndex && !this.exprColumns[n6].isConditional()) {
                Trace.error(69, this.exprColumns[n6]);
            }
            if (n6 >= n4 || n6 >= n5 || this.exprColumns[n6].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[n6]);
            }
            if (n6 < this.iResultLen) {
                resultMetaData.colLabels[n6] = expression.getAlias();
                resultMetaData.isLabelQuoted[n6] = expression.isAliasQuoted();
                resultMetaData.tableNames[n6] = expression.getTableName();
                resultMetaData.colNames[n6] = expression.getColumnName();
                if (resultMetaData.isTableColumn(n6)) {
                    resultMetaData.colNullable[n6] = expression.nullability;
                    resultMetaData.isIdentity[n6] = expression.isIdentity;
                    resultMetaData.isWritable[n6] = expression.isWritable;
                }
                resultMetaData.classNames[n6] = expression.getValueClassName();
            }
            ++n6;
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        if (this.iHavingIndex >= 0) {
            this.checkAggregateOrGroupByColumns(this.iHavingIndex, this.iHavingIndex + 1);
        }
        this.checkAggregateOrGroupByColumns(n4, n5);
        if (this.isDistinctSelect) {
            int n7 = n4;
            while (n7 < n5) {
                Trace.check(this.isSimilarIn(this.exprColumns[n7], 0, this.iResultLen), 71, this.exprColumns[n7]);
                ++n7;
            }
        }
        this.prepareSort();
    }

    void prepareUnions() throws HsqlException {
        int n = 0;
        Select select = this;
        while (select != null) {
            select = select.unionSelect;
            ++n;
        }
        if (n == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[n];
        n = 0;
        Select select2 = this;
        while (select2 != null) {
            this.unionArray[n] = select2;
            this.unionMaxDepth = select2.unionDepth > this.unionMaxDepth ? select2.unionDepth : this.unionMaxDepth;
            select2 = select2.unionSelect;
            ++n;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    private int getLimitCount(int n) throws HsqlException {
        this.limitStart = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg().getValue(null);
        int n2 = this.limitCount = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg2().getValue(null);
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        boolean bl = false;
        if (n != 0 && !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0) {
            bl = true;
        }
        return bl ? this.limitStart + n : Integer.MAX_VALUE;
    }

    Result getResult(Session session, int n) throws HsqlException {
        n = this.getLimitCount(n);
        Result result = this.unionType == 0 ? this.getSingleResult(session, n) : this.getResultMain(session);
        this.sortResult(result);
        result.setColumnCount(this.iResultLen);
        result.trimResult(this.limitStart, this.limitCount);
        return result;
    }

    private Result getResultMain(Session session) throws HsqlException {
        Result[] resultArray = new Result[this.unionArray.length];
        int n = 0;
        while (n < this.unionArray.length) {
            resultArray[n] = this.unionArray[n].getSingleResult(session, Integer.MAX_VALUE);
            ++n;
        }
        int n2 = this.unionMaxDepth;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < 2) {
                int n4 = 0;
                while (n4 < this.unionArray.length - 1) {
                    if (!(resultArray[n4] == null || this.unionArray[n4].unionDepth < n2 || n3 == 0 && this.unionArray[n4].unionType != 3 || n3 == 1 && this.unionArray[n4].unionType == 3)) {
                        int n5 = n4 + 1;
                        while (n5 < this.unionArray.length) {
                            if (resultArray[n5] != null) break;
                            ++n5;
                        }
                        if (n5 == this.unionArray.length) break;
                        this.unionArray[n4].mergeResults(resultArray[n4], resultArray[n5]);
                        resultArray[n5] = resultArray[n4];
                        resultArray[n4] = null;
                    }
                    ++n4;
                }
                ++n3;
            }
            --n2;
        }
        return resultArray[resultArray.length - 1];
    }

    private void mergeResults(Result result, Result result2) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                result.append(result2);
                result.removeDuplicates(this.iResultLen);
                break;
            }
            case 2: {
                result.append(result2);
                break;
            }
            case 3: {
                result.removeDifferent(result2, this.iResultLen);
                break;
            }
            case 4: {
                result.removeSecond(result2, this.iResultLen);
            }
        }
    }

    private Result getSingleResult(Session session, int n) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult();
        }
        Result result = this.buildResult(n, session);
        if (this.isDistinctSelect) {
            result.removeDuplicates(this.iResultLen);
        }
        return result;
    }

    private void prepareSort() {
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int n = this.iHavingIndex > 0 ? this.iHavingIndex + 1 : this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
        int n2 = n;
        int n3 = 0;
        while (n3 < this.iOrderLen) {
            int n4 = n2;
            if (this.exprColumns[n2].orderColumnIndex != -1) {
                n4 = this.exprColumns[n2].orderColumnIndex;
            }
            this.sortOrder[n3] = n4;
            this.sortDirection[n3] = this.exprColumns[n2].isDescending() ? -1 : 1;
            ++n2;
            ++n3;
        }
    }

    private void sortResult(Result result) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        result.sortResult(this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int n, int n2) throws HsqlException {
        if (n < n2) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            int n3 = n;
            while (n3 < n2) {
                this.exprColumns[n3].collectInGroupByExpressions(hsqlArrayList);
                ++n3;
            }
            int n4 = 0;
            int n5 = hsqlArrayList.size();
            while (n4 < n5) {
                Expression expression = (Expression)hsqlArrayList.get(n4);
                Trace.check(this.inAggregateOrGroupByClause(expression), 67, expression);
                ++n4;
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (this.isGrouped) {
            return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(expression, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return expression.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression expression, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (expression.similarTo(this.exprColumns[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Result buildResult(int var1_1, Session var2_2) throws HsqlException {
        var3_3 = new GroupedResult(this, this.resultMetaData);
        var4_4 = this.exprColumns.length;
        var5_5 = this.tFilter.length;
        var6_6 = new boolean[var5_5];
        var7_7 = new boolean[var5_5];
        var8_8 = 0;
        while (var8_8 >= 0) {
            var9_9 = this.tFilter[var8_8];
            if (!var6_6[var8_8]) {
                var10_10 = var9_9.findFirst(var2_2);
                var11_13 = var9_9.isOuterJoin != false && var10_10 == 0 && var7_7[var8_8] == false && var9_9.nonJoinIsNull == false && var9_9.nextOuter(var2_2) != false ? 1 : 0;
                var7_7[var8_8] = var11_13;
                var6_6[var8_8] = var10_10;
            } else {
                var10_10 = var9_9.next(var2_2);
                var11_13 = var9_9.isOuterJoin != false && var10_10 == 0 && var6_6[var8_8] == false && var7_7[var8_8] == false && var9_9.nonJoinIsNull == false && var9_9.nextOuter(var2_2) != false ? 1 : 0;
                var7_7[var8_8] = var11_13;
                var6_6[var8_8] = var10_10;
            }
            if (var10_10 == 0 && var11_13 == 0) {
                --var8_8;
                continue;
            }
            if (var8_8 >= var5_5 - 1) ** GOTO lbl26
            ++var8_8;
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7[var8_8--] = false;
lbl26:
                // 2 sources

                ** while (var7_7[var8_8])
            }
lbl27:
            // 1 sources

            if (this.queryCondition != null && !this.queryCondition.testCondition(var2_2)) continue;
            try {
                var12_14 = new Object[var4_4];
                var13_16 = var3_3.groupBegin;
                while (var13_16 < var3_3.groupEnd) {
                    var12_14[var13_16] = this.exprColumns[var13_16].getValue(var2_2);
                    ++var13_16;
                }
                var12_14 = var3_3.getRow(var12_14);
                var14_17 = 0;
                while (var14_17 < var3_3.groupBegin) {
                    var12_14[var14_17] = this.isAggregated != false && this.exprColumns[var14_17].isAggregate() != false ? this.exprColumns[var14_17].updateAggregatingValue(var2_2, var12_14[var14_17]) : this.exprColumns[var14_17].getValue(var2_2);
                    ++var14_17;
                }
                var15_18 = var3_3.groupEnd;
                while (var15_18 < var4_4) {
                    var12_14[var15_18] = this.isAggregated != false && this.exprColumns[var15_18].isAggregate() != false ? this.exprColumns[var15_18].updateAggregatingValue(var2_2, var12_14[var15_18]) : this.exprColumns[var15_18].getValue(var2_2);
                    ++var15_18;
                }
                var3_3.addRow(var12_14);
                if (var3_3.size() < var1_1) continue;
                break;
            }
            catch (HsqlInternalException var12_15) {
                // empty catch block
            }
        }
        if (this.isAggregated && !this.isGrouped && var3_3.size() == 0) {
            var9_9 = new Object[var4_4];
            var10_10 = 0;
            while (var10_10 < var4_4) {
                var9_9[var10_10] = this.exprColumns[var10_10].isAggregate() != false ? null : this.exprColumns[var10_10].getValue(var2_2);
                ++var10_10;
            }
            var3_3.addRow(var9_9);
        }
        var9_9 = var3_3.iterator();
        while (var9_9.hasNext()) {
            var10_12 = (Object[])var9_9.next();
            if (this.isAggregated) {
                var11_13 = 0;
                while (var11_13 < var4_4) {
                    if (this.exprColumns[var11_13].isAggregate()) {
                        var10_12[var11_13] = this.exprColumns[var11_13].getAggregatedValue(var2_2, var10_12[var11_13]);
                    }
                    ++var11_13;
                }
            }
            if (this.iHavingIndex < 0 || ((Boolean)var10_12[this.iHavingIndex]).booleanValue()) continue;
            var9_9.remove();
        }
        return var3_3.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        int n = 0;
        while (n < this.iResultLen) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n < this.iResultLen - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append("FROM");
        int n2 = 0;
        while (n2 < this.tFilter.length) {
            TableFilter tableFilter = this.tFilter[n2];
            if (n2 != 0 && tableFilter.isOuterJoin) {
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(',');
            ++n2;
        }
        stringBuffer.append(' ').append("WHERE").append(' ');
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            TableFilter tableFilter = this.tFilter[n3];
            ++n3;
        }
        stringBuffer.append(' ').append("GROUP").append(' ');
        int n4 = this.iResultLen;
        while (n4 < this.iResultLen + this.iGroupLen) {
            stringBuffer.append(this.exprColumns[n4].getDDL());
            if (n4 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n4;
        }
        stringBuffer.append(' ').append("HAVING").append(' ');
        int n5 = this.iHavingIndex;
        while (n5 < this.iHavingIndex + this.exprColumns.length) {
            stringBuffer.append(this.exprColumns[n5].getDDL());
            if (n5 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n5;
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    stringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        int n6 = this.iResultLen + this.iGroupLen;
        int n7 = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : n6;
        int n8 = n7 + this.iOrderLen;
        stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
        int n9 = n7;
        while (n9 < n8) {
            stringBuffer.append(this.exprColumns[n9].getDDL());
            if (n9 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n9;
        }
        return stringBuffer;
    }

    boolean resolveAll(boolean bl) throws HsqlException {
        boolean bl2 = true;
        if (this.isResolved) {
            return true;
        }
        this.resolve();
        boolean bl3 = bl2 = bl2 && this.checkResolved(bl);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            this.unionSelect.resolveAll(bl);
        }
        this.isResolved = bl2;
        return bl2;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String toString() {
        this.preProcess();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            stringBuffer.append("start=[").append(this.limitCondition.getArg()).append("]\n");
            stringBuffer.append("limit=[").append(this.limitCondition.getArg2()).append("]\n");
        }
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n = this.exprColumns.length - this.iOrderLen;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.exprColumns[n2]);
            ++n2;
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n3]);
            stringBuffer.append("\n]");
            ++n3;
        }
        stringBuffer.append("]\n");
        stringBuffer.append("eCondition=[").append(this.queryCondition).append("]\n");
        stringBuffer.append("havingCondition=[").append(this.havingCondition).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.unionSelect).append("]\n");
        }
        return stringBuffer.toString();
    }

    private void preProcess() {
        try {
            this.getResult(null, 1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        int n = 0;
        while (n < this.iResultLen) {
            Expression expression = this.exprColumns[n];
            resultMetaData.colTypes[n] = expression.getDataType();
            resultMetaData.colSizes[n] = expression.getColumnSize();
            resultMetaData.colScales[n] = expression.getColumnScale();
            resultMetaData.colLabels[n] = expression.getAlias();
            resultMetaData.isLabelQuoted[n] = expression.isAliasQuoted();
            resultMetaData.tableNames[n] = expression.getTableName();
            resultMetaData.colNames[n] = expression.getColumnName();
            if (resultMetaData.isTableColumn(n)) {
                resultMetaData.colNullable[n] = expression.nullability;
                resultMetaData.isIdentity[n] = expression.isIdentity;
                resultMetaData.isWritable[n] = expression.isWritable;
            }
            ++n;
        }
        return result;
    }
}

