/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.User;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager {
    int sessionIdCount;
    private IntKeyHashMap sessionMap = new IntKeyHashMap();
    Session sysSession;

    public SessionManager(Database database, User user) {
        this.sysSession = this.newSession(database, user, false);
    }

    public Session newSession(Database database, User user, boolean bl) {
        Session session = new Session(database, user, true, bl, this.sessionIdCount);
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session getSysSession() {
        return this.sysSession;
    }

    public void closeAllSessions() {
        Iterator iterator = this.sessionMap.values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session == this.sysSession) continue;
            iterator.remove();
            session.close();
        }
    }

    void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    void clearAll() {
        this.sessionMap.clear();
    }

    Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    Session getSession(int n) {
        return (Session)this.sessionMap.get(n);
    }

    public Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = (Session)iterator.next();
            ++n;
        }
        return sessionArray;
    }
}

