/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.BaseTable;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    static final String DEFAULT_PK = "";
    public HashMappedList columnList;
    Index[] indexList;
    private int[] primaryKeyCols;
    private int[] primaryKeyTypes;
    private int[] primaryKeyColsSequence;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    boolean needsRowID;
    int[] nullRowIDCols;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    private int[] colSizes;
    private boolean[] colNullable;
    private Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    private boolean isText;
    private boolean isView;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    protected int columnCount;
    protected int visibleColumnCount;
    public Database database;
    protected DataFileCache cache;
    protected HsqlNameManager.HsqlName tableName;
    private int tableType;
    protected int ownerSessionId;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;
    PersistentStore rowStore;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceSize;
        this.sqlEnforceStrictSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 0: 
            case 1: {
                this.isTemp = true;
                break;
            }
            case 2: {
                this.isTemp = true;
                this.ownerSessionId = n2;
                break;
            }
            case 4: {
                if (!database.logger.hasLog()) {
                    n = 3;
                    break;
                }
                this.cache = database.logger.getCache();
                this.isCached = true;
                break;
            }
            case 5: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.isCached = true;
                this.ownerSessionId = n2;
                break;
            }
            case 6: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.isCached = true;
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        if (this.isText || this.isCached) {
            this.rowStore = new RowStore();
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new Index[0];
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (database.isFilesReadOnly() && this.checkTableFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(Session session, String string) {
        if (this.isTemp && session != null && session.getId() != this.ownerSessionId) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isSystem() {
        return this.tableType == 0 || this.tableType == 1 || this.tableType == 8;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.isFilesReadOnly() && this.checkTableFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean checkTableFileBased() {
        return this.isCached || this.isText;
    }

    int getOwnerSessionId() {
        return this.ownerSessionId;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, this.constraintList.length, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Index getConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 2 && ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) {
                return constraint.getMainIndex();
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.isEquivalent(table, nArray, this, nArray2)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForIndex(Index index) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getMainIndex() == index && constraint.getType() == 2) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(String string, int n) throws HsqlException {
        Column column = new Column(this.database.nameManager.newHsqlName(string, false), true, n, 0, 0, false, 0L, 0L, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws HsqlException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        Trace.doAssert(this.primaryKeyCols == null, "Table.addColumn");
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
        ++this.visibleColumnCount;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        int n2 = 0;
        while (n2 < n) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.colLabels[n2], resultMetaData.isLabelQuoted[n2]), true, resultMetaData.colTypes[n2], resultMetaData.colSizes[n2], resultMetaData.colScales[n2], false, 0L, 0L, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = select.exprColumns[n2];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, 0L, 0L, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    void renameTable(String string, boolean bl) throws HsqlException {
        String string2 = this.tableName.name;
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
        this.renameTableInCheckConstraints(string2, string);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType, this.ownerSessionId);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= this.columnCount || nArray2[n] >= table.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[n]).getType() != table.getColumn(nArray2[n]).getType()) {
                throw Trace.error(57);
            }
            ++n;
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws HsqlException {
        int[] nArray;
        Table table = this.duplicate();
        int n3 = 0;
        while (n3 < this.visibleColumnCount + 1) {
            block10: {
                block8: {
                    block9: {
                        if (n3 != n) break block8;
                        if (n2 <= 0) break block9;
                        table.addColumn(column);
                        break block8;
                    }
                    if (n2 < 0) break block10;
                }
                if (n3 == this.visibleColumnCount) break;
                table.addColumn(this.getColumn(n3));
            }
            ++n3;
        }
        int[] nArray2 = nArray = this.primaryKeyCols.length == 0 ? null : this.primaryKeyCols;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        table.constraintList = this.constraintList;
        int n4 = 1;
        while (n4 < this.getIndexCount()) {
            Index index;
            Index index2 = this.getIndex(n4);
            if (!(string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null)) {
                throw Trace.error(123);
            }
            ++n4;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    Table moveDefinitionPK(HsqlNameManager.HsqlName hsqlName, int[] nArray) throws HsqlException {
        if (this.hasPrimaryKey() && nArray != null || !this.hasPrimaryKey() && nArray == null) {
            throw Trace.error(25);
        }
        Table table = this.duplicate();
        int n = 0;
        while (n < this.visibleColumnCount) {
            table.addColumn(this.getColumn(n).duplicate());
            ++n;
        }
        table.createPrimaryKey(hsqlName, nArray, true);
        table.constraintList = this.constraintList;
        int n2 = 1;
        while (n2 < this.getIndexCount()) {
            Index index = this.getIndex(n2);
            table.createAdjustedIndex(index, -1, 0);
            ++n2;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    void updateConstraintsTables(Table table, int n, int n2) throws HsqlException {
        int n3 = 0;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            constraint.replaceTable(table, this, n, n2);
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(constraint);
            }
            ++n3;
        }
    }

    private void recompileCheckConstraints() throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(constraint);
            }
            ++n;
        }
    }

    private void recompileCheckConstraint(Constraint constraint) throws HsqlException {
        Expression expression;
        String string = constraint.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(this.database.getSessionManager().getSysSession(), this.database, tokenizer);
        constraint.core.check = expression = parser.parseExpression();
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this, expression);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.checkFilter.setAsCheckFilter();
        constraint.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String string) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3 && constraint.hasColumn(this, string)) {
                throw Trace.error(197, constraint.getName());
            }
            ++n;
        }
    }

    private void renameColumnInCheckConstraints(String string, String string2, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getColumnName() != string) continue;
                    expression.setColumnName(string2, bl);
                }
            }
            ++n;
        }
    }

    private void renameTableInCheckConstraints(String string, String string2) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getTableName() != string) continue;
                    expression.setTableName(string2);
                }
            }
            ++n;
        }
        this.recompileCheckConstraints();
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public int getInvisibleColumnCount() {
        return this.columnCount;
    }

    public int getIndexCount() {
        return this.indexList.length;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n;
    }

    public Index getPrimaryIndex() {
        return this.getIndex(0);
    }

    public int[] getPrimaryKey() {
        return this.primaryKeyCols.length == 0 ? null : this.primaryKeyCols;
    }

    public int[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.columnList.size()];
        this.nullRowIDCols = new int[this.columnList.size()];
        int n3 = 0;
        while (n3 < this.bestIndexForColumn.length) {
            this.bestIndexForColumn[n3] = -1;
            this.nullRowIDCols[n3] = -1;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.indexList.length) {
            block20: {
                int n5;
                int[] nArray2;
                Index index;
                block19: {
                    index = this.indexList[n4];
                    nArray2 = index.getColumns();
                    n5 = index.getVisibleColumns();
                    if (n4 != 0) break block19;
                    if (this.getPrimaryKey() == null) break block20;
                    bl = true;
                }
                if (this.bestIndexForColumn[nArray2[0]] == -1) {
                    this.bestIndexForColumn[nArray2[0]] = n4;
                }
                if (!index.isUnique()) {
                    if (this.bestIndex == null) {
                        this.bestIndex = index;
                    }
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        if (!this.colNullable[nArray2[n7]]) {
                            ++n6;
                        } else {
                            this.nullRowIDCols[nArray2[n7]] = nArray2[n7];
                        }
                        ++n7;
                    }
                    if (this.bestIndex != null) {
                        this.bestIndex = index;
                    }
                    if (n6 == n5) {
                        if (nArray == null || n != n2 || n5 < n) {
                            nArray = nArray2;
                            n = n5;
                            n2 = n5;
                            bl = true;
                        }
                    } else if (!(bl || nArray != null && n5 >= n && n6 <= n2)) {
                        nArray = nArray2;
                        n = n5;
                        n2 = n6;
                    }
                }
            }
            ++n4;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        ArrayUtil.sortArray(this.nullRowIDCols);
        int n8 = ArrayUtil.findNot(this.nullRowIDCols, -1);
        this.nullRowIDCols = n8 == -1 ? null : ArrayUtil.arraySlice(this.nullRowIDCols, 0, n8);
        boolean bl2 = this.needsRowID = this.getPrimaryKey() == null;
        if (this.hasPrimaryKey()) {
            this.bestIndex = this.getPrimaryIndex();
        }
    }

    void setDefaultExpression(int n, Expression expression) {
        Column column = this.getColumn(n);
        column.setDefaultExpression(expression);
        this.resetDefaultValues();
    }

    void resetDefaultValues() {
        this.hasDefaultValues = false;
        int n = 0;
        while (n < this.visibleColumnCount) {
            Column column = this.getColumn(n);
            this.hasDefaultValues = this.hasDefaultValues || column.getDefaultExpression() != null;
            this.colDefaults[n] = column.getDefaultExpression();
            ++n;
        }
    }

    DataFileCache getCache() {
        return this.cache;
    }

    Index getIndexForColumn(int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && (this.tableType == 1 || this.tableType == 0)) {
            try {
                this.createIndex(new int[]{n}, null, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.indexList.length) {
            Index index2 = this.indexList[n2];
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (bl && index2.getVisibleColumns() > n) {
                n = index2.getVisibleColumns();
                index = index2;
            }
            ++n2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.getIndexCount();
        while (n < n2) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            if (ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) && (!bl || index.isUnique())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    public int[] getIndexRootsArray() {
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        while (n < this.getIndexCount()) {
            Node node = this.getIndex(n).getRoot();
            nArray[n] = node != null ? node.getKey() : -1;
            ++n;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    public void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        int n = 0;
        while (n < this.getIndexCount()) {
            int n2 = nArray[n];
            CachedRow cachedRow = null;
            if (n2 != -1) {
                cachedRow = (CachedRow)this.rowStore.get(n2);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(n);
            }
            this.getIndex(n).setRoot(node);
            ++n;
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached && !this.isText, 22);
        Tokenizer tokenizer = new Tokenizer(string);
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        while (n < this.getIndexCount()) {
            int n2;
            nArray[n] = n2 = tokenizer.getInt();
            ++n;
        }
        this.setIndexRoots(nArray);
        long l = tokenizer.getBigint();
        this.identitySequence.reset(l);
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        Object object;
        int n;
        Trace.doAssert(this.primaryKeyCols == null, "Table.createPrimaryKey(column)");
        if (nArray == null) {
            nArray = new int[]{};
            ++this.columnCount;
        } else {
            n = 0;
            while (n < nArray.length) {
                if (bl) {
                    this.getColumn(nArray[n]).setNullable(false);
                }
                this.getColumn(nArray[n]).setPrimaryKey(true);
                ++n;
            }
        }
        this.primaryKeyCols = nArray;
        this.colTypes = new int[this.visibleColumnCount];
        this.colDefaults = new Expression[this.visibleColumnCount];
        this.colSizes = new int[this.visibleColumnCount];
        this.colNullable = new boolean[this.visibleColumnCount];
        this.defaultColumnMap = new int[this.visibleColumnCount];
        n = 0;
        while (n < this.visibleColumnCount) {
            object = this.getColumn(n);
            this.colTypes[n] = ((Column)object).getType();
            this.colSizes[n] = ((Column)object).getSize();
            this.colNullable[n] = ((Column)object).isNullable();
            this.defaultColumnMap[n] = n;
            if (((Column)object).isIdentity()) {
                this.identitySequence.reset(((Column)object).identityStart, ((Column)object).identityIncrement);
            }
            ++n;
        }
        this.primaryKeyTypes = new int[this.primaryKeyCols.length];
        ArrayUtil.copyColumnValues(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        this.resetDefaultValues();
        object = hsqlName != null ? hsqlName : Table.makeSysPKName(this);
        this.createPrimaryIndex(nArray, (HsqlNameManager.HsqlName)object);
        this.setBestRowIdentifiers();
    }

    static HsqlNameManager.HsqlName makeSysPKName(Table table) throws HsqlException {
        return table.database.nameManager.newHsqlName("SYS_PK", table.tableName.name, table.tableName.isNameQuoted);
    }

    void createPrimaryIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int n;
        int[] nArray2;
        if (nArray.length == 0) {
            nArray = new int[]{this.visibleColumnCount};
            nArray2 = new int[]{4};
            n = 0;
        } else {
            nArray2 = new int[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = this.colTypes[nArray[n2]];
                ++n2;
            }
            n = nArray.length;
        }
        Index index = new Index(hsqlName, this, nArray, nArray2, true, true, false, n);
        this.addIndex(index);
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        Index index = this.indexList[n];
        Index index2 = this.getPrimaryIndex();
        RowIterator rowIterator = index2.firstRow();
        int n2 = 0;
        int n3 = 0;
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Node node = row.getNode(n - 1);
                Node node2 = Node.newNode(row, n, this);
                node2.nNext = node.nNext;
                node.nNext = node2;
                ++n2;
                index.insert(node2);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n3 = 72;
        }
        catch (HsqlException hsqlException) {
            n3 = 9;
        }
        rowIterator = index2.firstRow();
        int n4 = 0;
        while (n4 < n2) {
            Row row = rowIterator.next();
            Node node = row.getNode(0);
            int n5 = n;
            while (--n5 > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
            ++n4;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        throw Trace.error(n3);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        return this.indexList[n];
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        Trace.doAssert(this.primaryKeyCols != null, "createIndex");
        int[] nArray2 = this.indexList[0].getColumns();
        int[] nArray3 = this.indexList[0].getColumnTypes();
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray4 = new int[n + n2];
        int[] nArray5 = new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray4[n3] = nArray[n3];
            nArray5[n3] = this.colTypes[nArray4[n3]];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray4[n + n4] = nArray2[n4];
            nArray5[n + n4] = nArray3[n4];
            ++n4;
        }
        Index index = new Index(hsqlName, this, nArray4, nArray5, bl, bl2, bl3, n);
        int n5 = this.addIndex(index);
        this.setBestRowIdentifiers();
        return n5;
    }

    private int addIndex(Index index) {
        int n = 0;
        while (n < this.indexList.length) {
            Index index2 = this.indexList[n];
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
            ++n;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, n, 1);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet, boolean bl) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (!bl && index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (hashSet == null || !hashSet.contains(constraint)) {
                if (constraint.isIndexFK(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.isIndexUnique(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n;
        }
    }

    boolean isEmpty() {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).isEmpty();
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.visibleColumnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.visibleColumnCount];
    }

    Object[] getNewRow() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.columnCount];
        if (blArray != null && this.hasDefaultValues) {
            int n = 0;
            while (n < this.visibleColumnCount) {
                Expression expression = this.colDefaults[n];
                if (!blArray[n] && expression != null) {
                    objectArray[n] = expression.getValue(session, this.colTypes[n]);
                }
                ++n;
            }
        }
        return objectArray;
    }

    void dropIndex(String string) throws HsqlException {
        Index index;
        int n = 1;
        while (n < this.getIndexCount()) {
            index = this.getIndex(n);
            if (index.getName().name.equals(string)) {
                this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
                this.setBestRowIdentifiers();
                break;
            }
            ++n;
        }
        index = this.getPrimaryIndex();
        RowIterator rowIterator = index.firstRow();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n2 = n - 1;
            Node node = row.getNode(0);
            while (n2-- > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
        }
    }

    void moveData(Session session, Table table, int n, int n2) throws HsqlException {
        Object object;
        Object object2 = null;
        if (n2 > 0) {
            object = this.getColumn(n);
            object2 = ((Column)object).getDefaultValue(session);
        }
        object = table.rowIterator();
        while (object.hasNext()) {
            Row row = object.next();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = this.getNewRow();
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
            this.enforceNullConstraints(objectArray2);
            this.insertFromScript(objectArray2);
        }
        table.drop();
    }

    int insert(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        this.fireAll(session, 3);
        while (record != null) {
            this.insertRow(session, record.data);
            record = record.next;
            ++n;
        }
        this.fireAll(session, 0);
        return n;
    }

    void insert(Session session, Object[] objectArray) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, objectArray);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] objectArray) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, objectArray);
        }
        this.setIdentityColumn(session, objectArray);
        this.checkRowDataInsert(session, objectArray);
        this.insertNoCheck(session, objectArray);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, objectArray);
            this.checkRowDataInsert(session, objectArray);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insert(result);
        if (this.isTemp || this.isText || !this.database.logger.hasLog()) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.database.logger.writeInsertStatement(session, this, record.data);
            record = record.next;
        }
    }

    private Row insertNoCheck(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, row);
        }
        if (!this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
        return row;
    }

    public void insertNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, row);
        }
    }

    void insertNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(row);
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    int insert(Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.insert(record.data);
            record = record.next;
            ++n;
        }
        return n;
    }

    public void insertFromScript(Object[] objectArray) throws HsqlException {
        this.updateIdentityValue(objectArray);
        this.insert(objectArray);
    }

    public void insert(Object[] objectArray) throws HsqlException {
        Object object;
        if (objectArray.length != this.columnCount) {
            object = this.getNewRow();
            ArrayUtil.copyArray(objectArray, object, this.visibleColumnCount);
            objectArray = object;
        } else {
            int n = this.visibleColumnCount;
            while (n < this.columnCount) {
                objectArray[n] = null;
                ++n;
            }
        }
        object = this.newRow(objectArray);
        this.indexRow((Row)object);
    }

    protected void insertNoChange(CachedRow cachedRow) throws HsqlException {
        Object[] objectArray = cachedRow.getData();
        this.updateIdentityValue(objectArray);
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        this.indexRow(cachedRow);
    }

    protected void enforceNullConstraints(Object[] objectArray) throws HsqlException {
        int n = 0;
        while (n < this.visibleColumnCount) {
            if (objectArray[n] == null && !this.colNullable[n]) {
                Trace.throwerror(10, "column: " + this.getColumn((int)n).columnName.name + " table: " + this.tableName.name);
            }
            ++n;
        }
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    protected void updateIdentityValue(Object[] objectArray) throws HsqlException {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null) {
            this.identitySequence.getValue(number.longValue());
        }
    }

    void enforceFieldValueLimits(Object[] objectArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            int n = 0;
            while (n < this.visibleColumnCount) {
                if (this.colSizes[n] != 0 && objectArray[n] != null) {
                    objectArray[n] = Table.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            if (nArray == null) {
                this.enforceFieldValueLimits(objectArray);
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (this.colSizes[n2] != 0 && objectArray[n2] != null) {
                    objectArray[n2] = Table.enforceSize(objectArray[n2], this.colTypes[n2], this.colSizes[n2], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl, boolean bl2) throws HsqlException {
        if (n2 == 0) {
            return object;
        }
        switch (n) {
            case 1: {
                return Table.padOrTrunc((String)object, n2, bl, bl2);
            }
            case 12: {
                return Table.padOrTrunc((String)object, n2, false, bl2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl, boolean bl2) throws HsqlException {
        if (bl2 && StringUtil.rTrimSize(string) > n) {
            throw Trace.error(124);
        }
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (!bl) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n2, cArray, 0);
        int n3 = n2;
        while (n3 < n) {
            cArray[n3] = 32;
            ++n3;
        }
        return new String(cArray);
    }

    void fireAll(Session session, int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.triggerLists[n];
        if (hsqlArrayList == null) {
            return;
        }
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        while (n2 < n3) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n2);
            triggerDef.pushPair(session, objectArray, objectArray2);
            ++n2;
        }
    }

    void fireAll(Session session, int n) {
        if (this.triggerLists[n] != null) {
            this.fireAll(session, n, null, null);
        }
    }

    void addTrigger(TriggerDef triggerDef) {
        if (this.triggerLists[triggerDef.vectorIndex] == null) {
            this.triggerLists[triggerDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[triggerDef.vectorIndex].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    if (triggerDef.name.name.equals(string)) {
                        hsqlArrayList.remove(n3);
                        triggerDef.terminate();
                    }
                    --n3;
                }
                if (hsqlArrayList.isEmpty()) {
                    this.triggerLists[n2] = null;
                }
            }
            ++n2;
        }
    }

    void dropTriggers() {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    triggerDef.terminate();
                    --n3;
                }
                this.triggerLists[n2] = null;
            }
            ++n2;
        }
    }

    static void checkCascadeDelete(Session session, Table table, HashMappedList hashMappedList, Row row, boolean bl, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (n < n2) {
            RowIterator rowIterator;
            Constraint constraint = table.constraintList[n];
            if (constraint.getType() == 1 && constraint.getRef() != null && (rowIterator = constraint.findFkRef(row.getData(), true, bl)).hasNext()) {
                boolean bl2;
                Table table2 = constraint.getRef();
                boolean bl3 = bl2 = table2.getNextConstraintIndex(0, 1) != -1;
                if (bl || bl2) {
                    Row row2;
                    Index index = constraint.getRefIndex();
                    int[] nArray = constraint.getMainColumns();
                    int[] nArray2 = constraint.getRefColumns();
                    Object[] objectArray = row.getData();
                    boolean bl4 = constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4;
                    HashMappedList hashMappedList2 = null;
                    if (bl4 && (hashMappedList2 = (HashMappedList)hashMappedList.get(table2)) == null) {
                        hashMappedList2 = new HashMappedList();
                        hashMappedList.add(table2, hashMappedList2);
                    }
                    while ((row2 = rowIterator.next()) != null && !row2.isDeleted() && index.compareRowNonUnique(objectArray, nArray, row2.getData()) == 0) {
                        if (bl4) {
                            int n3;
                            Object[] objectArray2 = table2.getNewRow();
                            System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                            if (constraint.getDeleteAction() == 2) {
                                n3 = 0;
                                while (n3 < nArray2.length) {
                                    objectArray2[nArray2[n3]] = null;
                                    ++n3;
                                }
                            } else {
                                n3 = 0;
                                while (n3 < nArray2.length) {
                                    Column column = table2.getColumn(nArray2[n3]);
                                    objectArray2[nArray2[n3]] = column.getDefaultValue(session);
                                    ++n3;
                                }
                            }
                            if (bl2 && hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table2, null, row2, objectArray2, nArray2, null, hashSet);
                                hashSet.remove(constraint);
                            }
                            if (bl && (table2 != table || !row2.equals(row))) {
                                Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray2);
                            }
                        } else if (bl2) {
                            if (table2 != table) {
                                if (hashSet.add(constraint)) {
                                    Table.checkCascadeDelete(session, table2, hashMappedList, row2, bl, hashSet);
                                    hashSet.remove(constraint);
                                }
                            } else if (row2 != row) {
                                Table.checkCascadeDelete(session, table2, hashMappedList, row2, bl, hashSet);
                            }
                        }
                        if (!bl || bl4 || row2.isDeleted()) continue;
                        table2.deleteNoRefCheck(session, row2);
                    }
                    rowIterator.release();
                }
            }
            ++n;
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray, Table table2, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (n < n2) {
            int[] nArray2;
            Constraint constraint = table.constraintList[n];
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if ((table2 == null || constraint.getMain() != table2) && ArrayUtil.countCommonElements(nArray, constraint.getRefColumns()) != 0) {
                    constraint.hasMainRef(objectArray);
                }
            } else if (constraint.getType() == 1 && constraint.getRef() != null && (nArray2 = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) != null) {
                RowIterator rowIterator;
                int[] nArray3 = constraint.getMainColumns();
                int[] nArray4 = constraint.getRefColumns();
                boolean bl = true;
                int n3 = 0;
                while (n3 < nArray3.length) {
                    if (!row.getData()[nArray3[n3]].equals(objectArray[nArray3[n3]])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (!bl && (rowIterator = constraint.findFkRef(row.getData(), false, false)).hasNext()) {
                    Table table3 = constraint.getRef();
                    boolean bl2 = table3.getNextConstraintIndex(0, 1) != -1;
                    Index index = constraint.getRefIndex();
                    HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(table3);
                    if (hashMappedList2 == null) {
                        hashMappedList2 = new HashMappedList();
                        hashMappedList.add(table3, hashMappedList2);
                    }
                    Row row2 = rowIterator.next();
                    while (row2 != null && index.compareRowNonUnique(row.getData(), nArray3, row2.getData()) == 0) {
                        int n4;
                        Object[] objectArray2 = table3.getNewRow();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        if (constraint.getUpdateAction() == 2) {
                            n4 = 0;
                            while (n4 < nArray4.length) {
                                objectArray2[nArray4[n4]] = null;
                                ++n4;
                            }
                        } else if (constraint.getUpdateAction() == 4) {
                            n4 = 0;
                            while (n4 < nArray4.length) {
                                Column column = table3.getColumn(nArray4[n4]);
                                objectArray2[nArray4[n4]] = column.getDefaultValue(session);
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray4, null, hashSet);
                                hashSet.remove(constraint);
                            }
                        } else {
                            n4 = 0;
                            while (n4 < nArray3.length) {
                                objectArray2[nArray4[n4]] = objectArray[nArray3[n4]];
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray2, table, hashSet);
                                hashSet.remove(constraint);
                            }
                        }
                        Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray4);
                        row2 = rowIterator.next();
                    }
                }
            }
            ++n;
        }
    }

    static void mergeUpdate(HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            int n = 0;
            while (n < nArray.length) {
                objectArray2[nArray[n]] = objectArray[nArray[n]];
                ++n;
            }
        } else {
            hashMappedList.add(row, objectArray);
        }
    }

    static boolean mergeKeepUpdate(HashMappedList hashMappedList, int[] nArray, Row row, Object[] objectArray) throws HsqlException {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            if (Index.compareRows(row.getData(), objectArray, nArray) != 0 && Index.compareRows(objectArray, objectArray2, nArray) != 0) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                objectArray[nArray[n]] = objectArray2[nArray[n]];
                ++n;
            }
            hashMappedList.put(row, objectArray);
        } else {
            hashMappedList.add(row, objectArray);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList hashMappedList) {
        int n = 0;
        while (n < hashMappedList.size()) {
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n);
            hashMappedList2.clear();
            ++n;
        }
    }

    int delete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        Row row;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            n = 0;
            while (n < hsqlArrayList.size()) {
                row = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, row, false, hashSet);
                ++n;
            }
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            n = 0;
            while (n < hsqlArrayList.size()) {
                row = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, row, true, hashSet);
                ++n;
            }
        }
        n = 0;
        while (n < hsqlArrayList.size()) {
            row = (Row)hsqlArrayList.get(n);
            if (!row.isDeleted()) {
                this.deleteNoRefCheck(session, row);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < hashMappedList.size()) {
            Table table = (Table)hashMappedList.getKey(n2);
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n2);
            table.updateRowSet(session, hashMappedList2, null, false);
            hashMappedList2.clear();
            ++n2;
        }
        this.fireAll(session, 1);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList;
        return hsqlArrayList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(session, 10, objectArray, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, objectArray, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean bl) throws HsqlException {
        if (row.isDeleted()) {
            return;
        }
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        int n = this.getIndexCount() - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, row);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    public void deleteNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Object object;
        RowIterator rowIterator;
        Row row = null;
        if (this.hasPrimaryKey()) {
            rowIterator = this.getPrimaryIndex().findFirstRow(objectArray, this.primaryKeyColsSequence);
            row = rowIterator.next();
        } else {
            object = new int[this.visibleColumnCount];
            ArrayUtil.fillSequence(object);
            if (this.bestIndex == null) {
                rowIterator = this.rowIterator();
                while ((row = rowIterator.next()) != null && Index.compareRows(row.getData(), objectArray, object) != 0) {
                }
            } else {
                rowIterator = this.bestIndex.findFirstRow(objectArray);
                while ((row = rowIterator.next()) != null) {
                    if (Index.compareRows(row.getData(), objectArray, this.bestIndex.getColumns()) != 0) {
                        row = null;
                        break;
                    }
                    if (Index.compareRows(row.getData(), objectArray, object) != 0) continue;
                }
            }
        }
        if (row == null) {
            return;
        }
        int n = this.indexList.length - 1;
        while (n >= 0) {
            object = row.getNode(n);
            this.getIndex(n).delete((Node)object);
            --n;
        }
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, row);
        }
    }

    void deleteNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Row row = this.getIndex(0).findRow(objectArray);
        int n = this.indexList.length - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row.delete();
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    int update(Session session, HashMappedList hashMappedList, int[] nArray) throws HsqlException {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        int n = 0;
        while (n < hashMappedList.size()) {
            objectArray2 = (Object[])hashMappedList.get(n);
            this.setIdentityColumn(session, objectArray2);
            this.enforceFieldValueLimits(objectArray2, nArray);
            this.enforceNullConstraints(objectArray2);
            ++n;
        }
        if (this.database.isReferentialIntegrity()) {
            int n2 = 0;
            while (n2 < hashMappedList.size()) {
                Object[] objectArray3 = (Object[])hashMappedList.get(n2);
                object = (Row)hashMappedList.getKey(n2);
                Table.checkCascadeUpdate(session, this, hashMappedList2, (Row)object, objectArray3, nArray, null, hashSet);
                ++n2;
            }
        }
        this.fireAll(session, 5);
        objectArray2 = (HashMappedList)hashMappedList2.get(this);
        if (objectArray2 != null) {
            int n3 = 0;
            while (n3 < objectArray2.size()) {
                object = (Row)objectArray2.getKey(n3);
                objectArray = (Object[])objectArray2.get(n3);
                Table.mergeKeepUpdate(hashMappedList, nArray, (Row)object, objectArray);
                ++n3;
            }
            objectArray2.clear();
        }
        int n4 = 0;
        while (n4 < hashMappedList2.size()) {
            object = (Table)hashMappedList2.getKey(n4);
            objectArray = (HashMappedList)hashMappedList2.get(n4);
            ((Table)object).updateRowSet(session, (HashMappedList)objectArray, null, false);
            objectArray.clear();
            ++n4;
        }
        this.updateRowSet(session, hashMappedList, nArray, true);
        this.fireAll(session, 2);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        Table.clearUpdateLists(this.tableUpdateList);
        return hashMappedList.size();
    }

    void updateRowSet(Session session, HashMappedList hashMappedList, int[] nArray, boolean bl) throws HsqlException {
        Object object;
        int n = hashMappedList.size() - 1;
        while (n >= 0) {
            Row row = (Row)hashMappedList.getKey(n);
            object = (Object[])hashMappedList.get(n);
            if (row.isDeleted()) {
                if (bl) {
                    throw Trace.error(199);
                }
                hashMappedList.remove(n);
            } else {
                int n2 = 0;
                while (n2 < this.constraintList.length) {
                    Constraint constraint = this.constraintList[n2];
                    if (constraint.getType() == 3) {
                        constraint.checkCheckConstraint(session, (Object[])object);
                    }
                    ++n2;
                }
                this.deleteNoCheck(session, row, true);
            }
            --n;
        }
        int n3 = 0;
        while (n3 < hashMappedList.size()) {
            object = (Row)hashMappedList.getKey(n3);
            Object[] objectArray = (Object[])hashMappedList.get(n3);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            this.insertNoCheck(session, objectArray);
            if (this.triggerLists[8] != null) {
                this.fireAll(session, 8, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            ++n3;
        }
    }

    void checkRowDataInsert(Session session, Object[] objectArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = 0;
            int n2 = this.constraintList.length;
            while (n < n2) {
                this.constraintList[n].checkInsert(session, objectArray);
                ++n;
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, nArray);
        this.enforceNullConstraints(objectArray);
        int n = 0;
        while (n < this.constraintList.length) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 3) {
                constraint.checkCheckConstraint(session, objectArray);
            }
            ++n;
        }
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached && !this.isText;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.getIndexCount()) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName().name)) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            if (this.constraintList[n].getName().name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    Column getColumn(int n) {
        return (Column)this.columnList.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        String string2 = column.columnName.name;
        int n = this.getColumnNr(string2);
        this.columnList.setKey(n, string);
        column.columnName.rename(string, bl);
        this.renameColumnInCheckConstraints(string2, string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return this.indexList[n];
    }

    public Index[] getIndexes() {
        return this.indexList;
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isText) {
            CachedDataRow cachedDataRow = (CachedDataRow)this.rowStore.get(n);
            cachedDataRow.nPrimaryNode = node;
            return cachedDataRow;
        }
        if (this.isCached) {
            return (CachedRow)this.rowStore.get(n);
        }
        return null;
    }

    void addRowToStore(Row row) throws HsqlException {
        if (this.isCached && this.cache != null) {
            try {
                this.cache.add((CachedRow)row);
            }
            catch (IOException iOException) {
                throw new HsqlException(iOException);
            }
        } else if (this.needsRowID) {
            row.getData()[this.visibleColumnCount] = ValuePool.getInt((int)this.rowIdSequence.getValue());
        }
    }

    void registerRow(CachedRow cachedRow) {
    }

    void removeRow(CachedRow cachedRow) throws HsqlException {
        this.rowStore.remove(cachedRow.getPos());
    }

    /*
     * Unable to fully structure code
     */
    void indexRow(Row var1_1) throws HsqlException {
        block5: {
            var2_2 = 0;
            try {
                var3_3 = null;
                while (var2_2 < this.getIndexCount()) {
                    var3_3 = var1_1.getNextNode(var3_3);
                    this.getIndex(var2_2).insert(var3_3);
                    ++var2_2;
                }
                break block5;
            }
            catch (HsqlException var3_4) {
                var4_5 = this.getIndex(var2_2);
                var5_6 = var4_5.isConstraint;
                --var2_2;
                ** while (var2_2 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var6_7 = var1_1.getNode(var2_2);
                this.getIndex(var2_2).delete((Node)var6_7);
                --var2_2;
                continue;
            }
lbl19:
            // 1 sources

            var1_1.delete();
            if (var5_6) {
                var6_7 = this.getConstraintForIndex(var4_5);
                var7_8 = var6_7 == null ? "" : var6_7.getName().name;
                throw Trace.error(104, var7_8);
            }
            throw var3_4;
        }
    }

    void clearAllRows() {
        int n = 0;
        while (n < this.getIndexCount()) {
            this.getIndex(n).clearAll();
            ++n;
        }
        this.identitySequence.reset();
        this.rowIdSequence.reset();
    }

    void drop() throws HsqlException {
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    String getSchemaName() {
        if (!this.database.getProperties().isPropertyTrue("hsqldb.schemas")) {
            return null;
        }
        switch (this.tableType) {
            case 0: {
                return "DEFINITION_SCHEMA";
            }
            case 8: {
                return "INFORMATION_SCHEMA";
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return "PUBLIC";
            }
            case 2: 
            case 5: {
                Session session = this.database.sessionManager.getSession(this.ownerSessionId);
                if (session == null) {
                    return null;
                }
                if (session.getId() == this.ownerSessionId) {
                    return session.getUsername();
                }
                return null;
            }
        }
        return null;
    }

    public int getRowCount() throws HsqlException {
        return this.getPrimaryIndex().size();
    }

    public void resetRowId() throws HsqlException {
        if (this.isCached && !this.isText) {
            return;
        }
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        RowIterator rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n = (int)this.rowIdSequence.getValue();
            row.setPos(n);
            if (!this.needsRowID) continue;
            row.getData()[this.visibleColumnCount] = ValuePool.getInt(n);
        }
    }

    Row newRow(Object[] objectArray) throws HsqlException {
        Row row;
        try {
            if (this.isText) {
                row = new CachedDataRow(this, objectArray);
                this.rowStore.add(row);
            } else if (this.isCached) {
                row = new CachedRow(this, objectArray);
                this.rowStore.add(row);
            } else {
                row = new Row(this, objectArray);
                int n = (int)this.rowIdSequence.getValue();
                row.setPos(n);
                if (this.needsRowID) {
                    row.getData()[this.visibleColumnCount] = ValuePool.getInt(n);
                }
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException);
        }
        return row;
    }

    public class RowStore
    implements PersistentStore {
        public CachedObject get(int n) {
            try {
                return Table.this.cache.get(n, this, false);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public CachedObject getKeep(int n) {
            try {
                return Table.this.cache.get(n, this, true);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public int getStorageSize(int n) {
            try {
                return Table.this.cache.get(n, this, false).getStorageSize();
            }
            catch (HsqlException hsqlException) {
                return 0;
            }
        }

        public void add(CachedObject cachedObject) throws IOException {
            if (((Row)cachedObject).oData[0] == null) {
                Table.this.cache.add(cachedObject);
            }
            Table.this.cache.add(cachedObject);
        }

        public CachedObject get(RowInputInterface rowInputInterface) {
            try {
                if (Table.this.isText) {
                    return new CachedDataRow(Table.this, rowInputInterface);
                }
                CachedRow cachedRow = new CachedRow(Table.this, rowInputInterface);
                if (((Row)cachedRow).oData[0] == null) {
                    cachedRow.getPos();
                }
                return cachedRow;
            }
            catch (HsqlException hsqlException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public CachedObject getNewInstance(int n) {
            return null;
        }

        public void remove(int n) {
            try {
                Table.this.cache.remove(n, this);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }

        public void release(int n) {
            Table.this.cache.release(n);
        }
    }
}

