/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Token;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.BooleanConverter;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

public class Tokenizer {
    private static final int NO_TYPE = 0;
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int BOOLEAN = 9;
    private static final int DATE = 10;
    private static final int TIME = 11;
    private static final int TIMESTAMP = 12;
    private static final int NULL = 13;
    private static final int QUOTED_IDENTIFIER = 14;
    private static final int REMARK_LINE = 15;
    private static final int REMARK = 16;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private boolean bWait;
    static IntValueHashMap valueTokens = new IntValueHashMap();

    public Tokenizer() {
    }

    public Tokenizer(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
    }

    public void reset(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
        this.oValue = null;
        this.tokenIndex = 0;
        this.nextTokenIndex = 0;
        this.beginIndex = 0;
        this.iType = 0;
        this.sToken = null;
        this.sLongNameFirst = null;
        this.bWait = false;
    }

    void back() throws HsqlException {
        Trace.doAssert(!this.bWait, "back");
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.tokenIndex;
        this.bWait = true;
    }

    void getThis(String string) throws HsqlException {
        this.getToken();
        if (!this.sToken.equals(string)) {
            throw Trace.error(11, 160, new Object[]{this.sToken, string});
        }
    }

    static void matchThis(String string, String string2) throws HsqlException {
        if (!string2.equals(string)) {
            throw Trace.error(11, 160, new Object[]{string2, string});
        }
    }

    String getCurrentThis(String string) throws HsqlException {
        if (!this.sToken.equals(string)) {
            throw Trace.error(11, 160, new Object[]{this.sToken, string});
        }
        return this.sToken;
    }

    public boolean isGetThis(String string) throws HsqlException {
        this.getToken();
        if (this.sToken.equals(string)) {
            return true;
        }
        this.back();
        return false;
    }

    String getUserOrPassword() throws HsqlException {
        this.getToken();
        switch (this.iType) {
            case 6: {
                return this.sToken.toUpperCase(Locale.ENGLISH);
            }
            case 1: {
                return this.sToken;
            }
            case 14: {
                return this.sToken.toUpperCase(Locale.ENGLISH);
            }
        }
        throw Trace.error(11, this.sToken);
    }

    boolean wasValue() {
        switch (this.iType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    boolean wasQuotedIdentifier() {
        return this.iType == 14;
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 14) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    boolean wasIdentifier() {
        if (this.iType == 14) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getName() throws HsqlException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    String getIdentifier() throws HsqlException {
        this.getToken();
        if (!this.wasIdentifier()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    public String getString() throws HsqlException {
        this.getToken();
        return this.sToken;
    }

    int getInt() throws HsqlException {
        long l = this.getBigint();
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw Trace.error(16, Types.getTypeString(this.getType()));
        }
        return (int)l;
    }

    long getBigint() throws HsqlException {
        boolean bl = false;
        this.getToken();
        if (this.sToken.equals("MINUS")) {
            bl = true;
            this.getToken();
        }
        Object object = this.getAsValue();
        int n = this.getType();
        if (n != 4 && n != -5 && n != 3) {
            throw Trace.error(16, Types.getTypeString(n));
        }
        if (n == 3) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bl && bigDecimal.subtract(new BigDecimal(9.223372036854776E18)).equals(new BigDecimal(1.0))) {
                return Long.MIN_VALUE;
            }
            throw Trace.error(16, Types.getTypeString(n));
        }
        long l = ((Number)object).longValue();
        return bl ? -l : l;
    }

    Object getInType(int n) throws HsqlException {
        this.getToken();
        Object object = this.getAsValue();
        int n2 = this.getType();
        if (n2 != n) {
            throw Trace.error(16, Types.getTypeString(n2));
        }
        return object;
    }

    public int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 16;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
        }
        return 0;
    }

    Object getAsValue() throws HsqlException {
        if (!this.wasValue()) {
            throw Trace.error(11, this.sToken);
        }
        switch (this.iType) {
            case 13: {
                return null;
            }
            case 6: {
                return this.sToken;
            }
            case 7: {
                return ValuePool.getLong(Long.parseLong(this.sToken));
            }
            case 4: {
                if (this.sToken.length() < 11) {
                    try {
                        return ValuePool.getInt(Integer.parseInt(this.sToken));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.sToken.length() < 20) {
                    try {
                        this.iType = 7;
                        return ValuePool.getLong(Long.parseLong(this.sToken));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.iType = 8;
                return new BigDecimal(this.sToken);
            }
            case 5: {
                double d = new Double(this.sToken);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case 8: {
                return new BigDecimal(this.sToken);
            }
            case 9: {
                return BooleanConverter.getBoolean(this.sToken);
            }
            case 10: {
                return HsqlDateTime.dateValue(this.sToken);
            }
            case 11: {
                return HsqlDateTime.timeValue(this.sToken);
            }
            case 12: {
                return HsqlDateTime.timestampValue(this.sToken);
            }
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int n, int n2) {
        return this.sCommand.substring(n, n2);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int n) {
        this.beginIndex = n;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws HsqlException {
        if (!this.bWait) ** GOTO lbl6
        this.bWait = false;
        this.iIndex = this.nextTokenIndex;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl6:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.sCommand.charAt((int)this.iIndex)))
        }
lbl7:
        // 1 sources

        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        var1_1 = this.sCommand.charAt(this.iIndex);
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = '\u0000';
        if (Character.isJavaIdentifierStart(var1_1)) {
            this.iType = 1;
        } else if (Character.isDigit(var1_1)) {
            this.iType = 4;
            var3_3 = true;
        } else {
            switch (var1_1) {
                case '(': {
                    this.sToken = "(";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ')': {
                    this.sToken = ")";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ',': {
                    this.sToken = ",";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '*': {
                    this.sToken = "*";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '=': {
                    this.sToken = "=";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ';': {
                    this.sToken = ";";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '+': {
                    this.sToken = "+";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '%': {
                    this.sToken = "%";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '?': {
                    this.sToken = "?";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '\"': {
                    this.iType = 14;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    var1_1 = this.sCommand.charAt(this.iIndex);
                    if (var1_1 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.iType = 2;
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    var7_7 = var1_1;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    var2_2 = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(var1_1));
                }
            }
        }
        var8_8 = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                var1_1 = ' ';
                var6_6 = true;
                Trace.check(this.iType != 6 && this.iType != 14, 12);
            } else {
                var1_1 = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(var1_1)) break;
                    this.sToken = this.sCommand.substring(var8_8, this.iIndex).toUpperCase(Locale.ENGLISH);
                    if (var1_1 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.iType = 2;
                    } else if (var1_1 != '(' && (var9_9 = Tokenizer.valueTokens.get((Object)this.sToken, -1)) != -1) {
                        this.iType = var9_9;
                    }
                    return;
                }
                case 6: 
                case 14: {
                    break;
                }
                case 16: {
                    if (var6_6) {
                        this.iType = 0;
                        return;
                    }
                    if (var1_1 != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 15: {
                    if (var6_6) {
                        this.iType = 0;
                        return;
                    }
                    if (var1_1 != '\r' && var1_1 != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (var1_1 == '/' && var7_7 == '/') {
                        this.iType = 15;
                        break;
                    }
                    if (var1_1 == '-' && var7_7 == '-') {
                        this.iType = 15;
                        break;
                    }
                    if (var1_1 == '*' && var7_7 == '/') {
                        this.iType = 16;
                        break;
                    }
                    if (var1_1 == '>' || var1_1 == '=' || var1_1 == '|') break;
                    this.sToken = this.sCommand.substring(var8_8, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(var1_1)) {
                        var3_3 = true;
                        break;
                    }
                    if (var1_1 == '.') {
                        this.iType = 8;
                        if (var2_2) {
                            throw Trace.error(11, ".");
                        }
                        var2_2 = true;
                        break;
                    }
                    if (var1_1 == 'E' || var1_1 == 'e') {
                        if (var4_4) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        var5_5 = true;
                        var2_2 = true;
                        var4_4 = true;
                        break;
                    }
                    if (var1_1 == '-' && var5_5) {
                        var5_5 = false;
                        break;
                    }
                    if (var1_1 == '+' && var5_5) {
                        var5_5 = false;
                        break;
                    }
                    var5_5 = false;
                    if (!var3_3) {
                        if (var2_2 && var8_8 == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(var1_1));
                    }
                    this.sToken = this.sCommand.substring(var8_8, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char c) throws HsqlException {
        try {
            int n = this.iIndex;
            boolean bl = false;
            while (true) {
                if ((n = this.sCommand.indexOf(c, n)) < 0) {
                    throw Trace.error(12);
                }
                if (n >= this.iLength - 1 || this.sCommand.charAt(n + 1) != c) break;
                bl = true;
                n += 2;
            }
            char[] cArray = new char[n - this.iIndex];
            this.sCommand.getChars(this.iIndex, n, cArray, 0);
            int n2 = cArray.length;
            if (bl) {
                n2 = 0;
                int n3 = 0;
                while (n3 < cArray.length) {
                    if (cArray[n3] == c) {
                        ++n3;
                    }
                    cArray[n2] = cArray[n3];
                    ++n3;
                    ++n2;
                }
            }
            this.iIndex = ++n;
            return new String(cArray, 0, n2);
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Exception exception) {
            exception.getMessage();
            return null;
        }
    }

    int getLength() {
        return this.iLength;
    }

    static {
        valueTokens.put("NULL", 13);
        valueTokens.put("TRUE", 9);
        valueTokens.put("FALSE", 9);
    }
}

