/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HTTPClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcCallableStatement;
import org.hsqldb.jdbc.jdbcDatabaseMetaData;
import org.hsqldb.jdbc.jdbcPreparedStatement;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class jdbcConnection
implements Connection {
    HsqlProperties connProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private Object rootWarning_mutex = new Object();

    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, 1003);
        return jdbcStatement2;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, string, 1003);
            return jdbcPreparedStatement2;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, string, 1003);
            return jdbcCallableStatement2;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string);
        int n4 = 0;
        while (n4 < n2) {
            char c = stringBuffer.charAt(n4);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        break;
                    }
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (c != '{') break;
                    stringBuffer.setCharAt(n4++, ' ');
                    n4 = StringUtil.skipSpaces(string, n4);
                    if (string.regionMatches(true, n4, "fn ", 0, 3) || string.regionMatches(true, n4, "oj ", 0, 3) || string.regionMatches(true, n4, "ts ", 0, 3)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "d ", 0, 2) || string.regionMatches(true, n4, "t ", 0, 2)) {
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "call ", 0, 5)) {
                        n4 += 4;
                    } else if (string.regionMatches(true, n4, "?= call ", 0, 8)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                        n4 += 5;
                    } else if (string.regionMatches(true, n4, "escape ", 0, 7)) {
                        n4 += 6;
                    } else {
                        throw new SQLException(Trace.getMessage(138, true, new Object[]{string.substring(--n4)}), "S0010", 62);
                    }
                    ++n3;
                    n = 3;
                    break;
                }
                case 1: 
                case 4: {
                    if (c != '\'') break;
                    --n;
                    break;
                }
                case 2: 
                case 5: {
                    if (c != '\"') break;
                    n -= 2;
                    break;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        break;
                    }
                    if (c == '\"') {
                        n = 5;
                        break;
                    }
                    if (c == '}') {
                        stringBuffer.setCharAt(n4, ' ');
                        n = --n3 == 0 ? 0 : 3;
                        break;
                    }
                    if (c != '{') break;
                    stringBuffer.setCharAt(n4++, ' ');
                    if (string.regionMatches(true, n4, "fn ", 0, 3) || string.regionMatches(true, n4, "oj ", 0, 3) || string.regionMatches(true, n4, "ts ", 0, 3)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "d ", 0, 2) || string.regionMatches(true, n4, "t ", 0, 2)) {
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "call ", 0, 5)) {
                        n4 += 4;
                    } else if (string.regionMatches(true, n4, "?= call ", 0, 8)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                        n4 += 5;
                    } else if (string.regionMatches(true, n4, "escape ", 0, 7)) {
                        n4 += 6;
                    } else {
                        throw new SQLException(Trace.getMessage(138, true, new Object[]{string.substring(--n4)}), "S0010", 62);
                    }
                    ++n3;
                    n = 3;
                }
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.sessionProxy.close();
        this.sessionProxy = null;
        this.rootWarning = null;
        this.connProperties = null;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new jdbcDatabaseMetaData(this);
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnly(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        try {
            return this.sessionProxy.isReadOnly();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.checkClosed();
    }

    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        if (n != 1) {
            throw Util.notSupported;
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 1;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            SQLWarning sQLWarning = this.rootWarning;
            return sQLWarning;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        return new jdbcStatement(this, n);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            return new jdbcPreparedStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            return new jdbcCallableStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkClosed();
        throw Util.notSupported;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported;
    }

    public jdbcConnection(HsqlProperties hsqlProperties) throws SQLException {
        boolean bl;
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl2 = bl = string3 == "hsqls://" || string3 == "https://";
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        try {
            if (string3 == "file:" || string3 == "mem:" || string3 == "res:") {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, hsqlProperties);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new HSQLClientConnection(string4, n, string5, string6, bl, string, string2);
                this.isNetConn = true;
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new HTTPClientConnection(string4, n, string5, string6, bl, string, string2);
                this.isNetConn = true;
            } else {
                throw Util.sqlException(62);
            }
            this.connProperties = hsqlProperties;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public jdbcConnection(Session session) throws HsqlException {
        this.isInternal = true;
        this.sessionProxy = session;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        if (this.isInternal) {
            return ((Session)this.sessionProxy).getInternalConnectionURL();
        }
        return this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(2);
        }
    }

    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    void clearWarningsNoCheck() {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    int xlateRSType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: {
                return n;
            }
            case 1005: {
                String string = "TYPE_SCROLL_SENSITIVE => TYPE_SCROLL_SENSITIVE";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1004;
            }
        }
        String string = "ResultSet type: " + n;
        throw Util.sqlException(62, string);
    }

    int xlateRSConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: {
                return n;
            }
            case 1008: {
                String string = "CONCUR_UPDATABLE => CONCUR_READ_ONLY";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1007;
            }
        }
        String string = "ResultSet concurrency: " + n;
        throw Util.sqlException(62, string);
    }

    int xlateRSHoldability(int n) throws SQLException {
        switch (n) {
            case 1: {
                return n;
            }
            case 2: {
                String string = "CLOSE_CURSORS_AT_COMMIT => HOLD_CURSORS_OVER_COMMIT";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1;
            }
        }
        String string = "ResultSet holdability: " + n;
        throw Util.sqlException(62, string);
    }
}

