/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long filePos;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.filename = string;
        this.rootsList = new int[database.getTables().size()][];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void process() throws HsqlException, IOException {
        Trace.printSystemOut("Defrag Transfer begins");
        HsqlArrayList hsqlArrayList = this.database.getTables();
        Storage storage = null;
        try {
            try {
                OutputStream outputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
                this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
                int n = 0;
                while (n < 32) {
                    this.fileStreamOut.write(0);
                    ++n;
                }
                this.filePos = 32L;
                int n2 = 0;
                int n3 = hsqlArrayList.size();
                while (n2 < n3) {
                    Table table = (Table)hsqlArrayList.get(n2);
                    if (table.getTableType() == 4) {
                        int[] nArray = this.writeTableToDataFile(table);
                        this.rootsList[n2] = nArray;
                    } else {
                        this.rootsList[n2] = null;
                    }
                    Trace.printSystemOut(table.getName().name + " complete");
                    ++n2;
                }
                this.fileStreamOut.close();
                storage = ScaledRAFile.newScaledRAFile(this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
                storage.seek(12L);
                storage.writeLong(this.filePos);
                int n4 = 0;
                int n5 = this.rootsList.length;
                while (n4 < n5) {
                    int[] nArray = this.rootsList[n4];
                    if (nArray != null) {
                        Trace.printSystemOut(StringUtil.getList(nArray, ",", ""));
                    }
                    ++n4;
                }
            }
            catch (IOException iOException) {
                throw Trace.error(29, this.filename + ".new");
            }
            Object var11_13 = null;
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (storage == null) return;
            storage.close();
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (storage == null) throw throwable;
            storage.close();
            throw throwable;
        }
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList hsqlArrayList = this.database.getTables();
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            if (table.getTableType() == 4) {
                int[] nArray = this.rootsList[n];
                table.setIndexRoots(nArray);
            }
            ++n;
        }
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] nArray = table.getIndexRootsArray();
        long l = this.filePos;
        int n = 0;
        doubleIntIndex.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator();
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIterator();
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            rowOutputBinary.reset();
            row.write(rowOutputBinary, doubleIntIndex);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.filePos += (long)row.getStorageSize();
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != -1) {
                int n3 = doubleIntIndex.findFirstEqualKeyIndex(nArray[n2]);
                if (n3 == -1) {
                    throw Trace.error(129);
                }
                nArray[n2] = doubleIntIndex.getValue(n3);
            }
            ++n2;
        }
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }
}

