/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;

public class Logger {
    Log log;
    public SimpleLog appLog;
    LockFile lf;
    boolean logStatements;
    boolean syncFile = false;

    public void openLog(Database database) throws HsqlException {
        String string = database.getPath();
        this.appLog = new SimpleLog(string + ".app.log", !database.isFilesReadOnly());
        this.appLog.sendLine("Database (re)opened: " + database.getFileAccess().getClass().getName() + " " + HsqlDateTime.getSytemTimeString());
        this.logStatements = false;
        if (!database.isFilesReadOnly()) {
            this.acquireLock(string);
        }
        this.log = new Log(database);
        this.log.open();
        this.logStatements = !database.isFilesReadOnly();
    }

    public boolean closeLog(int n) {
        if (this.log == null) {
            if (this.appLog != null) {
                this.appLog.sendLine("Database closed: " + HsqlDateTime.getSytemTimeString());
                this.appLog.close();
            }
            return true;
        }
        try {
            switch (n) {
                case -1: {
                    this.log.shutdown();
                    break;
                }
                case 0: {
                    this.log.close(false);
                    break;
                }
                case 1: 
                case 2: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable throwable) {
            if (this.appLog != null) {
                this.appLog.sendLine("Database closed: " + HsqlDateTime.getSytemTimeString());
                this.appLog.close();
            }
            this.log = null;
            return false;
        }
        if (this.appLog != null) {
            this.appLog.sendLine("Database closed: " + HsqlDateTime.getSytemTimeString());
            this.appLog.close();
        }
        this.log = null;
        return true;
    }

    public boolean hasLog() {
        return this.log != null;
    }

    public DataFileCache getCache() throws HsqlException {
        if (this.log != null) {
            return this.log.getCache();
        }
        return null;
    }

    public void logConnectUser(Session session) throws HsqlException {
        if (this.logStatements) {
            this.writeToLog(session, session.getUser().getConnectStatement());
        }
    }

    public void writeToLog(Session session, String string) throws HsqlException {
        if (this.logStatements) {
            int n = session == null ? 0 : session.getId();
            this.log.writeStatement(n, string);
        }
    }

    public void writeInsertStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.logStatements) {
            int n = session == null ? 0 : session.getId();
            this.log.writeInsertStatement(n, table, objectArray);
        }
    }

    public void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.logStatements) {
            int n = session == null ? 0 : session.getId();
            this.log.writeDeleteStatement(n, table, objectArray);
        }
    }

    public void writeSequenceStatement(Session session, NumberSequence numberSequence) throws HsqlException {
        if (this.logStatements) {
            int n = session == null ? 0 : session.getId();
            this.log.writeSequenceStatement(n, numberSequence);
        }
    }

    public void writeCommitStatement(Session session) throws HsqlException {
        if (this.logStatements) {
            int n = session == null ? 0 : session.getId();
            this.log.writeCommitStatement(n);
            this.synchLog();
        }
    }

    public void synchLog() {
        if (this.logStatements && this.syncFile) {
            this.log.synchLog();
        }
    }

    public void synchLogForce() {
        if (this.logStatements) {
            this.log.synchLog();
        }
    }

    public void checkpoint(boolean bl) throws HsqlException {
        if (this.logStatements) {
            this.log.checkpoint(bl);
        }
    }

    public void setLogSize(int n) {
        if (this.log != null) {
            this.log.setLogSize(n);
        }
    }

    public void setScriptType(int n) throws HsqlException {
        if (this.log != null) {
            this.log.setScriptType(n);
        }
    }

    public void setWriteDelay(int n) {
        if (this.log != null) {
            this.syncFile = n == 0;
            this.log.setWriteDelay(n);
        }
    }

    public int getWriteDelay() {
        return this.log != null ? this.log.getWriteDelay() : 0;
    }

    public int getLogSize() {
        return this.log != null ? this.log.getLogSize() : 0;
    }

    public int getScriptType() {
        return this.log != null ? this.log.getScriptType() : 0;
    }

    public DataFileCache openTextCache(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        return this.log.openTextCache(table, string, bl, bl2);
    }

    public void closeTextCache(Table table) throws HsqlException {
        this.log.closeTextCache(table);
    }

    public void acquireLock(String string) throws HsqlException {
        if (this.lf != null) {
            return;
        }
        this.lf = LockFile.newLockFileLock(string);
    }

    public void releaseLock() {
        block3: {
            try {
                if (this.lf != null) {
                    this.lf.tryRelease();
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
        this.lf = null;
    }
}

