/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String ignoredFirst = NL;
    protected Table table;
    int nextRowPos;

    TextCache(Table table, String string) throws HsqlException {
        super(table.database, string, null);
        this.table = table;
    }

    protected void initParams() throws HsqlException {
        this.storeOnInsert = true;
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(this.fileName, "=", ";", null);
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                throw Trace.error(75, 172);
            }
            case 1: {
                this.fileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Trace.error(75, 173, hsqlProperties.errorKeys[1]);
            }
        }
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        this.fs = this.translateSep(hsqlProperties.getProperty("fs", hsqlDatabaseProperties.getProperty("textdb.fs", ",")));
        this.vs = this.translateSep(hsqlProperties.getProperty("vs", hsqlDatabaseProperties.getProperty("textdb.vs", this.fs)));
        this.lvs = this.translateSep(hsqlProperties.getProperty("lvs", hsqlDatabaseProperties.getProperty("textdb.lvs", this.fs)));
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Trace.error(75, 174);
        }
        this.ignoreFirst = hsqlProperties.isPropertyTrue("ignore_first", hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first", false));
        this.isQuoted = hsqlProperties.isPropertyTrue("quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.quoted", true));
        this.isAllQuoted = hsqlProperties.isPropertyTrue("all_quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted", false));
        this.stringEncoding = this.translateSep(hsqlProperties.getProperty("encoding", hsqlDatabaseProperties.getProperty("textdb.encoding", "ASCII")));
        int n = hsqlProperties.getIntegerProperty("cache_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
        int n2 = hsqlProperties.getIntegerProperty("cache_size_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale", 10, 8, 20));
        int n3 = 1 << n;
        int n4 = 1 << n2;
        this.maxCacheSize = n3 * 3;
        this.maxCacheBytes = this.maxCacheSize * n4;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
        this.resetBuffers();
    }

    protected void resetBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = 0;
        n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }

    public void open(boolean bl) throws HsqlException {
        block5: {
            this.fileFreePosition = 0L;
            try {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.fileName, bl, 0, null, null);
                this.fileFreePosition = this.dataFile.length();
                if (this.fileFreePosition > Integer.MAX_VALUE) {
                    throw new IOException();
                }
                if (this.fileFreePosition != 0L || !this.ignoreFirst) break block5;
                byte[] byArray = null;
                try {
                    byArray = this.ignoredFirst.getBytes(this.stringEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = this.ignoredFirst.getBytes();
                }
                this.dataFile.write(byArray, 0, byArray.length);
                this.fileFreePosition = this.ignoredFirst.length();
            }
            catch (Exception exception) {
                throw Trace.error(29, 188, new Object[]{this.fileName, exception});
            }
        }
        this.cacheReadonly = bl;
    }

    void reopen() throws HsqlException {
        this.open(this.cacheReadonly);
    }

    public void close(boolean bl) throws HsqlException {
        if (this.dataFile == null) {
            return;
        }
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)NL.length();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 189, new Object[]{this.fileName, exception});
        }
    }

    void purge() throws HsqlException {
        if (this.dataFile == null) {
            return;
        }
        try {
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                this.dataFile.close();
                this.dataFile = null;
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 190, new Object[]{this.fileName, exception});
        }
    }

    public void remove(int n, PersistentStore persistentStore) throws HsqlException {
        CachedObject cachedObject = this.get(n, persistentStore, false);
        if (this.storeOnInsert) {
            int n2 = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            try {
                hsqlByteArrayOutputStream.fill(32, n2);
                hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
                this.dataFile.seek(n);
                this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
            }
            catch (IOException iOException) {
                throw Trace.error(29, iOException.toString());
            }
        }
        this.release(cachedObject.getPos());
    }

    public int getNextRowPos() {
        return this.nextRowPos;
    }

    protected boolean readObject(int n) throws IOException {
        ByteArray byteArray = new ByteArray(80);
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n2;
            this.dataFile.seek(n);
            while ((n2 = this.dataFile.read()) != -1) {
                int n3 = n2;
                if (n3 == 10) {
                    byteArray.append(10);
                    if (this.ignoreFirst && n == 0) {
                        this.ignoredFirst = byteArray.toString();
                        bl = true;
                    }
                    if (!bl) {
                        bl2 = true;
                        break;
                    }
                    n += byteArray.length();
                    byteArray.setLength(0);
                    bl = true;
                    ((RowInputText)this.rowIn).skippedLine();
                    continue;
                }
                if (n3 == 13) {
                    try {
                        n2 = this.dataFile.read();
                        if (n2 == -1) break;
                        n3 = n2;
                        if (n3 == 10) {
                            byteArray.append(10);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byteArray.append(10);
                    if (this.ignoreFirst && n == 0) {
                        this.ignoredFirst = byteArray.toString();
                        bl = true;
                    }
                    if (!bl) {
                        bl2 = true;
                        break;
                    }
                    n += byteArray.length();
                    byteArray.setLength(0);
                    bl = true;
                    ((RowInputText)this.rowIn).skippedLine();
                    continue;
                }
                if (n3 != 32) {
                    bl = false;
                }
                byteArray.append(n3);
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            ((RowInputText)this.rowIn).setSource(byteArray.toString(), n, byteArray.length());
            this.nextRowPos = n + byteArray.length();
            return true;
        }
        return false;
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    protected void setFileModified() throws IOException {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int n) {
            if (this.buflen >= this.buffer.length) {
                byte[] byArray = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buflen);
                this.buffer = byArray;
            }
            this.buffer[this.buflen] = (byte)n;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int n) {
            this.buflen = n;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

