/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    private RowOutputBinary out;

    public RowInputBinary() {
    }

    public RowInputBinary(byte[] byArray) {
        super(byArray);
    }

    public RowInputBinary(RowOutputBinary rowOutputBinary) {
        super(rowOutputBinary.getBuffer());
        this.out = rowOutputBinary;
    }

    protected byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public long readLongData() throws IOException {
        return this.readLong();
    }

    public String readString() throws IOException {
        int n = this.readInt();
        String string = StringConverter.readUTF(this.buf, this.pos, n);
        string = ValuePool.getString(string);
        this.pos += n;
        return string;
    }

    protected boolean checkNull() throws IOException {
        byte by = this.readByte();
        return by == 0;
    }

    protected String readChar(int n) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        return ValuePool.getInt(this.readShort());
    }

    protected Integer readInteger() throws IOException, HsqlException {
        return ValuePool.getInt(this.readInt());
    }

    protected Long readBigint() throws IOException, HsqlException {
        return ValuePool.getLong(this.readLong());
    }

    protected Double readReal(int n) throws IOException, HsqlException {
        return ValuePool.getDouble(this.readLong());
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        byte[] byArray = this.readByteArray();
        int n = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return ValuePool.getBigDecimal(new BigDecimal(bigInteger, n));
    }

    protected Boolean readBit() throws IOException, HsqlException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Time readTime() throws IOException, HsqlException {
        return new Time(HsqlDateTime.getNormalisedTime(this.readLong()));
    }

    protected Date readDate() throws IOException, HsqlException {
        long l = HsqlDateTime.getNormalisedDate(this.readLong());
        return ValuePool.getDate(l);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    protected Object readOther() throws IOException, HsqlException {
        return new JavaObject(this.readByteArray());
    }

    protected Binary readBinary(int n) throws IOException, HsqlException {
        return new Binary(this.readByteArray(), false);
    }

    public void resetRow(int n) {
        if (this.out != null) {
            this.out.reset(n);
            this.buf = this.out.getBuffer();
        }
        super.reset();
    }

    public void resetRow(int n, int n2) throws IOException {
        if (this.out != null) {
            this.out.reset(n2);
            this.buf = this.out.getBuffer();
        }
        super.resetRow(n, n2);
    }
}

