/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;

public class ScriptReaderText
extends ScriptReaderBase {
    BufferedReader d;
    RowInputTextLog rowIn = new RowInputTextLog();
    boolean isInsert;

    ScriptReaderText(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        while (this.readLoggedStatement()) {
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            Result result = session.sqlExecuteDirectNoPreChecks(this.statement);
            if (result == null || result.mode != 2) continue;
            this.db.logger.appLog.logContext(result.getException());
            throw Trace.error(78, 113, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        try {
            String string = null;
            this.db.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement()) {
                if (!this.rowIn.getTableName().equals(string)) {
                    string = this.rowIn.getTableName();
                    this.currentTable = this.db.getUserTable(null, string);
                }
                this.currentTable.insertFromScript(this.rowData);
                this.isInsert = false;
            }
            this.db.setReferentialIntegrity(true);
        }
        catch (Exception exception) {
            this.db.logger.appLog.logContext(exception);
            throw Trace.error(78, 114, new Object[]{new Integer(this.lineCount), exception.getMessage()});
        }
    }

    public boolean readLoggedStatement() throws IOException {
        String string = this.d.readLine();
        ++this.lineCount;
        this.statement = StringConverter.asciiToUnicode(string);
        if (this.statement == null) {
            return false;
        }
        this.processStatement();
        return true;
    }

    private void processStatement() throws IOException {
        try {
            if (this.statement.startsWith("/*C")) {
                int n = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
                this.statement = this.statement.substring(n + 2);
            }
            this.rowIn.setSource(this.statement);
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 5) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            String string = this.rowIn.getTableName();
            this.currentTable = this.db.getUserTable(null, string);
            if (this.statementType == 3) {
                int[] nArray = this.currentTable.getColumnTypes();
                this.rowData = this.rowIn.readData(nArray, this.currentTable.getInvisibleColumnCount());
            } else if (this.currentTable.hasPrimaryKey()) {
                int[] nArray = this.currentTable.getPrimaryKeyTypes();
                this.rowData = this.rowIn.readData(nArray, nArray.length);
            } else {
                int[] nArray = this.currentTable.getColumnTypes();
                this.rowData = this.rowIn.readData(nArray, this.currentTable.getColumnCount());
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    protected void openFile() throws IOException {
        super.openFile();
        this.d = new BufferedReader(new InputStreamReader(this.dataStreamIn));
    }

    public void close() {
        try {
            this.d.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

