/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.scriptio.ScriptWriterBinary;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.scriptio.ScriptWriterZipped;

public abstract class ScriptWriterBase
implements Runnable {
    Database db;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    boolean includeCachedData;
    long byteCount;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    static final int INSERT = 0;
    int sessionId;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    public static final int SCRIPT_TEXT_170 = 0;
    public static final int SCRIPT_BINARY_172 = 1;
    public static final int SCRIPT_ZIPPED_BINARY_172 = 3;
    private int syncCount;
    private Object timerTask;
    private int ticks;
    private volatile int writeDelay;

    public static ScriptWriterBase newScriptWriter(Database database, String string, boolean bl, boolean bl2, int n) throws HsqlException {
        if (n == 0) {
            return new ScriptWriterText(database, string, bl, bl2);
        }
        if (n == 1) {
            return new ScriptWriterBinary(database, string, bl, bl2);
        }
        return new ScriptWriterZipped(database, string, bl, bl2);
    }

    ScriptWriterBase() {
    }

    ScriptWriterBase(Database database, String string, boolean bl, boolean bl2) throws HsqlException {
        this.initBuffers();
        boolean bl3 = false;
        try {
            bl3 = database.getFileAccess().isStreamElement(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl3 && bl2) {
            throw Trace.error(29, string);
        }
        this.db = database;
        this.includeCachedData = bl;
        this.outFile = string;
        this.openFile();
    }

    public void reopen() throws HsqlException {
        this.openFile();
    }

    protected abstract void initBuffers();

    public synchronized void sync() {
        if (this.needsSync && this.fileStreamOut != null) {
            if (this.busyWriting) {
                this.forceSync = true;
                return;
            }
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException iOException) {
                Trace.printSystemOut("flush() or sync() error: " + iOException.getMessage());
            }
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    public void close() throws HsqlException {
        this.stop();
        try {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.flush();
                this.fileStreamOut.close();
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
        this.byteCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() throws HsqlException {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    protected void openFile() throws HsqlException {
        try {
            FileAccess fileAccess = this.db.getFileAccess();
            OutputStream outputStream = fileAccess.openOutputStreamElement(this.outFile);
            this.outDescriptor = fileAccess.getFileSync(outputStream);
            this.fileStreamOut = new BufferedOutputStream(outputStream, 8192);
        }
        catch (IOException iOException) {
            throw Trace.error(29, 115, new Object[]{iOException.getMessage(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException, HsqlException {
        Result result = DatabaseScript.getScript(this.db, !this.includeCachedData);
        this.writeSingleColumnResult(result);
    }

    protected void writeExistingData() throws HsqlException, IOException {
        HsqlArrayList hsqlArrayList = this.db.getTables();
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            boolean bl = false;
            switch (table.getTableType()) {
                case 3: {
                    bl = true;
                    break;
                }
                case 4: {
                    bl = this.includeCachedData;
                    break;
                }
                case 6: {
                    bl = this.includeCachedData && !table.isReadOnly();
                }
            }
            try {
                if (bl) {
                    this.writeTableInit(table);
                    RowIterator rowIterator = table.rowIterator();
                    while (rowIterator.hasNext()) {
                        this.writeRow(0, table, rowIterator.next().getData());
                    }
                    this.writeTableTerm(table);
                }
            }
            catch (Exception exception) {
                throw Trace.error(38, exception.getMessage());
            }
            ++n;
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table table) throws HsqlException, IOException {
    }

    protected void writeTableTerm(Table table) throws HsqlException, IOException {
        if (table.isDataReadOnly() && !table.isTemp() && !table.isText()) {
            StringBuffer stringBuffer = new StringBuffer("SET TABLE ");
            stringBuffer.append(table.getName().statementName);
            stringBuffer.append(" READONLY TRUE");
            this.writeLogStatement(stringBuffer.toString(), this.sessionId);
        }
    }

    protected void writeSingleColumnResult(Result result) throws HsqlException, IOException {
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            this.writeLogStatement((String)objectArray[0], this.sessionId);
        }
    }

    abstract void writeRow(int var1, Table var2, Object[] var3) throws HsqlException, IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void writeSessionId(int var1) throws IOException;

    public abstract void writeLogStatement(String var1, int var2) throws IOException, HsqlException;

    public abstract void writeInsertStatement(int var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeDeleteStatement(int var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeSequenceStatement(int var1, NumberSequence var2) throws HsqlException, IOException;

    public abstract void writeCommitStatement(int var1) throws HsqlException, IOException;

    public void run() {
        block3: {
            try {
                if (this.writeDelay != 0 && ++this.ticks >= this.writeDelay) {
                    this.sync();
                    this.ticks = 0;
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public void start() {
        this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, 1000L, this, false);
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

