/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    Vector rows = new Vector();

    public String getColumnName(int n) {
        return this.headers[n].toString();
    }

    public Class getColumnClass(int n) {
        Object object;
        if (this.rows.size() > 0 && (object = this.getValueAt(0, n)) != null) {
            return object.getClass();
        }
        return super.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public Vector getData() {
        return this.rows;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        Object[] objectArray = (Object[])this.rows.elementAt(n);
        if (n2 >= objectArray.length) {
            return null;
        }
        return objectArray[n2];
    }

    public void setHead(Object[] objectArray) {
        this.headers = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            this.headers[n] = objectArray[n];
            ++n;
        }
    }

    public void addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = objectArray[n];
            if (objectArray2[n] == null) {
                // empty if block
            }
            ++n;
        }
        this.rows.addElement(objectArray2);
    }

    public void clear() {
        this.rows.removeAllElements();
    }

    public void setJTable(JTable jTable) {
        this.jtable = jTable;
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n4 = 0;
        while (n4 < jTable.getColumnCount()) {
            tableColumn = jTable.getColumnModel().getColumn(n4);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width + 10;
            n2 = Integer.MIN_VALUE;
            int n5 = 0;
            while (n5 < Math.min(tableModel.getRowCount(), 30)) {
                TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(n5, n4);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(n5, n4), false, false, n5, n4);
                n3 = component.getPreferredSize().width;
                if (n3 >= n2) {
                    n2 = n3;
                }
                ++n5;
            }
            tableColumn.setPreferredWidth(Math.max(n, n2) + 10);
            ++n4;
        }
    }
}

