/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;
import org.hsqldb.util.TransferTable;

class OracleTransferHelper
extends TransferHelper {
    private final int ORACLE = 0;
    private final int HSQLDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    OracleTransferHelper() {
        System.out.println("simple init of OracleTransferHelper");
    }

    OracleTransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        super(transferDb, traceable, string);
    }

    void set(TransferDb transferDb, Traceable traceable, String string) {
        super.set(transferDb, traceable, string);
        String string2 = "ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'";
        System.out.println("dateFormatStmnt: " + string2);
        try {
            this.tracer.trace("Executing " + string2);
            transferDb.execute(string2);
        }
        catch (Exception exception) {
            this.tracer.trace("Ignoring error " + exception.getMessage());
            System.out.println("Ignoring error " + exception.getMessage());
        }
    }

    String fixupColumnDefRead(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        return this.fixupColumnDefRead(transferTable.Stmts.sDestTable, resultSetMetaData, string, resultSet, n);
    }

    String fixupColumnDefWrite(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        if (string.equals("SERIAL")) {
            String string2 = new String("_" + resultSet.getString(4) + "_seq");
            int n2 = 31 - string2.length();
            string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
            String string3 = "DROP SEQUENCE " + string2 + ";";
            transferTable.Stmts.sDestDrop = transferTable.Stmts.sDestDrop + string3;
        }
        int n3 = 0;
        while (n3 < this.Funcs.length) {
            String string4 = this.Funcs[n3][1];
            int n4 = string.indexOf(string4);
            if (n4 >= 0) {
                String string5 = string.substring(0, n4);
                string5 = string5 + this.Funcs[n3][0];
                string = string5 = string5 + string.substring(n4 + string4.length());
            }
            ++n3;
        }
        return string;
    }

    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void endDataTransfer() {
        try {
            this.db.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String fixupColumnDefRead(String string, ResultSetMetaData resultSetMetaData, String string2, ResultSet resultSet, int n) throws SQLException {
        String string3 = new String("_" + resultSet.getString(4) + "_seq");
        int n2 = 31 - string3.length();
        string3 = string.length() > n2 ? string.substring(0, n2) + string3 : string + string3;
        String string4 = "nextval('\"" + string3 + "\"'";
        if (string2.indexOf(string4) >= 0) {
            string2 = "SERIAL";
        }
        int n3 = 0;
        while (n3 < this.Funcs.length) {
            String string5 = this.Funcs[n3][0];
            int n4 = string2.indexOf(string5);
            if (n4 >= 0) {
                String string6 = string2.substring(0, n4);
                string6 = string6 + this.Funcs[n3][1];
                string2 = string6 = string6 + string2.substring(n4 + string5.length());
            }
            ++n3;
        }
        return string2;
    }
}

